% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.mean.R
\name{size.mean}
\alias{size.mean}
\title{Sample Size Determination for Testing Arithmetic Means}
\usage{
size.mean(delta, sample = c("two.sample", "one.sample"),
          alternative = c("two.sided", "less", "greater"),
          alpha = 0.05, beta = 0.1, check = TRUE, output = TRUE)
}
\arguments{
\item{delta}{a numeric value indicating the relative minimum difference
to be detected, \eqn{\delta}.}

\item{sample}{a character string specifying one- or two-sample t-test,
must be one of \code{"two.sample"} (default) or \code{"one.sample"}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{alpha}{type-I-risk, \eqn{\alpha}.}

\item{beta}{type-II-risk, \eqn{\beta}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{misty.object} with following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{type}      \tab type of the test (i.e., arithmetic mean) \cr
  \code{args}      \tab specification of function arguments \cr
  \code{result}       \tab list with the result, i.e., optimal sample size \cr
}
}
\description{
This function performs sample size computation for the one-sample and two-sample t-test
based on precision requirements (i.e., type-I-risk, type-II-risk and an effect size).
}
\examples{
#--------------------------------------
# Two-sided one-sample test
# H0: mu = mu.0, H1: mu != mu.0
# alpha = 0.05, beta = 0.2, delta = 0.5

size.mean(delta = 0.5, sample = "one.sample",
          alternative = "two.sided", alpha = 0.05, beta = 0.2)

#--------------------------------------
# One-sided one-sample test
# H0: mu <= mu.0, H1: mu > mu.0
# alpha = 0.05, beta = 0.2, delta = 0.5

size.mean(delta = 0.5, sample = "one.sample",
          alternative = "greater", alpha = 0.05, beta = 0.2)

#--------------------------------------
# Two-sided two-sample test
# H0: mu.1 = mu.2, H1: mu.1 != mu.2
# alpha = 0.01, beta = 0.1, delta = 1

size.mean(delta = 1, sample = "two.sample",
          alternative = "two.sided", alpha = 0.01, beta = 0.1)

#--------------------------------------
# One-sided two-sample test
# H0: mu.1 <= mu.2, H1: mu.1 > mu.2
# alpha = 0.01, beta = 0.1, delta = 1

size.mean(delta = 1, sample = "two.sample",
          alternative = "greater", alpha = 0.01, beta = 0.1)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Rasch, D., Pilz, J., Verdooren, L. R., & Gebhardt, G. (2011).
\emph{Optimal experimental design with R}. Boca Raton: Chapman & Hall/CRC.
}
\seealso{
\code{\link{size.prop}}, \code{\link{size.cor}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
