% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.test.R
\name{print.test}
\alias{print.test}
\title{Print test object}
\usage{
\method{print}{test}(x, digits = x$args$digits, p.digits = x$args$p.digits,
           check = TRUE, ...)
}
\arguments{
\item{x}{\code{test} object.}

\item{digits}{an integer value indicating the number of decimal places to be used for
displaying results.}

\item{p.digits}{an integer value indicating the number of decimal places to be used for
displaying the \emph{p}-value.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{test} object
}
\examples{
dat <- data.frame(y = c(2, 1, 4, 5, 3, 7, 8, 4, 1),
                  group = c(1, 1, 1, 2, 2, 2, 3, 3, 3))

# Levene's test based on the median
dat.levene <- levenes.test(y ~ group, data = dat, output = FALSE)

# Print test object with 5 digits for the p-value
print(dat.levene, p.digits = 5)
}
\seealso{
\code{\link{levenes.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
