% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.missoNet.R
\name{plot.cv.missoNet}
\alias{plot.cv.missoNet}
\title{Plot the cross-validation errors produced by cv.missoNet}
\usage{
\method{plot}{cv.missoNet}(
  x,
  type = c("cv.heatmap", "cv.scatter"),
  detailed.axes = TRUE,
  plt.surf = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted \code{'cv.missoNet'} object.}

\item{type}{A character string for the type of plot, can be either "\code{cv.heatmap}" (default) or "\code{cv.scatter}".}

\item{detailed.axes}{Logical: whether the detailed axes should be plotted. The default is \code{'TRUE'}.}

\item{plt.surf}{Logical: whether to draw the error surface. The default is \code{'TRUE'}. This is only needed when \code{'type'} = "\code{cv.scatter}".}

\item{...}{Other graphical arguments used by \sQuote{ComplexHeatmap::Heatmap} (\code{'type'} = "\code{cv.heatmap}") or \sQuote{scatterplot3d::scatterplot3d} (\code{'type'} = "\code{cv.scatter}").}
}
\value{
The plot object.
}
\description{
S3 method for plotting the cross-validation error surface from a fitted \code{'cv.missoNet'} object.
}
\examples{
## Simulate a dataset.
set.seed(123)  # reproducibility
sim.dat <- generateData(n = 200, p = 10, q = 10, rho = 0.1, missing.type = "MCAR")

\donttest{
## Perform a five-fold cross-validation on the simulated dataset.
cvfit <- cv.missoNet(X = sim.dat$X, Y = sim.dat$Z, kfold = 5,
                     fit.1se = TRUE, permute = TRUE, with.seed = 486)


## Plot the (standardized) mean cross-validated errors in a heatmap.
plot(cvfit, type = "cv.heatmap")

## Plot the (standardized) mean cross-validated errors in a 3D scatterplot.
plot(cvfit, type = "cv.scatter", plt.surf = TRUE)
}
}
\author{
Yixiao Zeng \email{yixiao.zeng@mail.mcgill.ca}, Celia M.T. Greenwood and Archer Yi Yang.
}
