% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_rank.R
\name{delete_MNAR_rank}
\alias{delete_MNAR_rank}
\title{Create MNAR values using a ranking mechanism}
\usage{
delete_MNAR_rank(ds, p, miss_cols, ties.method = "average")
}
\arguments{
\item{ds}{a data frame or matrix in which missing values will be created}

\item{p}{a numeric vector with length one or equal to length \code{miss_cols};
the probability that a value is missing}

\item{miss_cols}{a vector of column names or indices of columns in which
missing values will be created}

\item{ties.method}{how ties are handled, passed to \code{\link[base]{rank}}}
}
\value{
An object of the same class as \code{ds} with missing values
}
\description{
Create missing not at random (MNAR) values using a ranking mechanism in a
data frame or a matrix
}
\details{
The functions \code{delete_MNAR_rank} and \code{\link{delete_MAR_rank}} are sisters. The only difference between these two functions is the column that controls the generation of missing values. In \code{\link{delete_MAR_rank}} a separate column \code{ctrl_cols[i]} controls the generation of missing values in \code{miss_cols[i]}. In contrast, in \code{delete_MNAR_rank} the generation of missing values in \code{miss_cols[i]} is controlled by \code{miss_cols[i]} itself. All other aspects are identical for both functions. Therefore, further details can be found in \code{\link{delete_MAR_rank}}.
}
\examples{
ds <- data.frame(X = 1:20, Y = 101:120)
delete_MNAR_rank(ds, 0.2, "X")
}
\references{
Santos, M. S., Pereira, R. C., Costa, A. F., Soares, J. P.,
  Santos, J., & Abreu, P. H. (2019). Generating Synthetic Missing Data: A
  Review by Missing Mechanism. \emph{IEEE Access}, 7, 11651-11667
}
\seealso{
\code{\link{delete_MAR_rank}}

Other functions to create MNAR: 
\code{\link{delete_MNAR_1_to_x}()},
\code{\link{delete_MNAR_censoring}()},
\code{\link{delete_MNAR_one_group}()}
}
\concept{functions to create MNAR}
