% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strextr.R
\name{strextr}
\alias{strextr}
\title{Extract a Substring}
\usage{
strextr(x, pattern, sep = " ", mult = F, unlist = F, cores = 1)
}
\arguments{
\item{x}{Character vector.}

\item{pattern}{Regular expression.}

\item{sep}{Character string which separates the fields.}

\item{mult}{Logical, if multiple matching fields should be returned,
or otherwise NA.}

\item{unlist}{Logical, unlists multiple results.}

\item{cores}{Integer for number of computational cores to use.}
}
\value{
A list of character vectors containing the substrings that are
matching \code{pattern} and are separated by \code{sep} or \code{NA} if
the pattern could not be found.
}
\description{
This function extracts substring(s) which match a given pattern.
}
\details{
The function is deprecated and will be removed with \code{miscset} version 2.
It is recommended to use \link[stringr]{str_extract} or
\link[stringr]{str_extract_all} instead.
}
\examples{
#

library(stringr)

s <- c("A1 B1 C1","A2 B2", "AA A1", "AA", "B1 A1", "BB AB A1")

strextr(s, "^[AB][[:digit:]]$") # deprecated
str_extract(s, "[AB][:digit:]")

strextr(s, "^[AB][[:digit:]]$", mult = TRUE) # deprecated
str_extract_all(s, "[AB][:digit:]")

strextr(s, "^[AB][[:digit:]]$", mult = TRUE, unlist = TRUE) # deprecated
unlist(str_extract_all(s, "[AB][:digit:]")) # has no <NA> values

strextr(s, "^[C][[:digit:]]$") # deprecated
str_extract(s, "[C][:digit:]")

#
}
\author{
Sven E. Templer
}
\keyword{extract}
\keyword{string}
