% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDISC.R
\name{MDISC}
\alias{MDISC}
\title{Compute multidimensional discrimination index}
\usage{
MDISC(x, group = NULL)
}
\arguments{
\item{x}{an object of class 'SingleGroupClass', or an object of class 'MultipleGroupClass' if a suitable
\code{group} input were supplied}

\item{group}{group argument to pass to \code{\link{extract.group}} function. Required when the input object is
a multiple-group model}
}
\description{
Returns a vector containing the MDISC values for each item in the model input object (Reckase, 2009).
}
\examples{
\dontrun{

mod <- mirt(Science, 2)
MDISC(mod)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}

Reckase, M. D. (2009). Multidimensional Item Response Theory. Springer.
}
\seealso{
\code{\link{extract.group}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{discrimination}
