% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{daemons}
\alias{daemons}
\title{daemons (Background Processes)}
\usage{
daemons(...)
}
\arguments{
\item{...}{an integer to set the number of daemons. 'view' to view the
currently set number of daemons.}
}
\value{
Depending on the specified ... parameter:
    \itemize{
    \item{integer: integer change in number of daemons (created or destroyed).}
    \item{'view': integer number of currently set daemons.}
    \item{missing: the 'nanoSocket' for connecting to the daemons, or NULL if
    it is yet to be created.}
    }
}
\description{
Set or view the number of daemons (background processes). Create persistent
    background processes to send \code{\link{mirai}} requests. Setting a
    positive number of daemons provides a potentially more efficient solution
    for async operations as new processes no longer need to be created on an
    ad hoc basis.
}
\details{
\{mirai\} will revert to the default behaviour of creating a new
    background process for each request if the number of daemons is set to 0.

    It is highly recommended to shut down daemons by setting \code{daemons(0)}
    or explicitly unloading the package before exiting your R session. This
    will ensure that all processes exit cleanly and resources are freed.

    The current implementation is low-level and ensures tasks are
    evenly-distributed amongst daemons without actively managing a task queue.
    This approach provides a robust and resource-light solution, particularly
    well-suited to working with similar-length tasks, or where the number of
    concurrent tasks typically does not exceed the number of available
    daemons.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

# To create 4 background processes
daemons(4)
# To view the number of background processes
daemons("view")
# To destroy them all
daemons(0)
}

}
