% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimalistGODB.R
\name{parseGOA}
\alias{parseGOA}
\title{parseGOA}
\usage{
parseGOA(goa)
}
\arguments{
\item{goa}{character string path name to downloaded goa_human.gaf}
}
\value{
returns matrix with columns c("HGNC","GO","RELATION")
}
\description{
parse goa_human.gaf
}
\details{
download goa_human.gaf from https://current.geneontology.org/products/pages/downloads.html
}
\examples{
\dontrun{
# replace my path name for goa with your own!!
# this was obtained from the download sites listed in 'details' section
GOA<-parseGOA("~/goa_human.gaf")
# GOA[1:5,]
#      HGNC          GO           RELATION     
# [1,] "NUDT4B"      "GO:0003723" "enables"    
# [2,] "NUDT4B"      "GO:0005515" "enables"    
# [3,] "NUDT4B"      "GO:0046872" "enables"    
# [4,] "NUDT4B"      "GO:0005829" "located_in" 
# [5,] "TRBV20OR9-2" "GO:0002376" "involved_in"
}
# here is a small example that you can run
f<-system.file("extdata","goa_human.small.gaf",package="minimalistGODB")
GOAsmall<-parseGOA(f)


}
