% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{centrality}
\alias{centrality}
\alias{node_degree}
\alias{node_closeness}
\alias{node_betweenness}
\alias{node_eigenvector}
\title{Centrality for one- and two-mode networks}
\usage{
node_degree(
  object,
  weights = NULL,
  mode = "out",
  loops = TRUE,
  normalized = FALSE
)

node_closeness(
  object,
  weights = NULL,
  mode = "out",
  normalized = FALSE,
  cutoff = NULL
)

node_betweenness(
  object,
  weights = NULL,
  directed = TRUE,
  cutoff = NULL,
  nobigint = TRUE,
  normalized = FALSE
)

node_eigenvector(
  object,
  weights = NULL,
  directed = FALSE,
  scale = FALSE,
  normalized = FALSE
)
}
\arguments{
\item{object}{Either an igraph graph object or a matrix.}

\item{weights}{The weight of the edges to use for the calculation.
Will be evaluated in the context of the edge data.}

\item{mode}{How should edges be followed (in or out). By default, outdegree of
the node is calculated. Ignored for undirected graphs.}

\item{loops}{Should loops be included in the calculation}

\item{normalized}{For one-mode networks, should Borgatti and Everett normalization be applied?}

\item{cutoff}{maximum path length to use during calculations}

\item{directed}{Should direction of edges be used for the calculations}

\item{nobigint}{Should big integers be avoided during calculations}

\item{scale}{Should the scores be scaled to range between 0 and 1?}
}
\value{
Depending on how and what kind of an object is passed to the function,
the function will return a \code{tidygraph} object where the nodes have been updated

A numeric vector giving the betweenness centrality measure of each node.

A numeric vector giving the eigenvector centrality measure of each node.
}
\description{
These functions calculate common centrality measures for both one- and two-mode networks.
They accept as objects matrices and \code{igraph} graphs,
and can be used within a tidygraph workflow.
Importantly, these functions also offer correct normalization for two-mode networks.
}
\examples{
node_degree(mpn_elite_mex)
node_degree(ison_southern_women)
node_closeness(mpn_elite_mex)
node_closeness(ison_southern_women)
node_betweenness(mpn_elite_mex)
node_betweenness(ison_southern_women)
node_eigenvector(mpn_elite_mex)
node_eigenvector(ison_southern_women)
}
\references{
Borgatti, Stephen P., and Martin G. Everett (1997). "Network analysis of 2-mode data." \emph{Social Networks} 19(3): 243-270.

Faust, Katherine (1997). "Centrality in affiliation networks." \emph{Social Networks} 19(2): 157-191.
}
\seealso{
Other two-mode measures: 
\code{\link{centralization}},
\code{\link{cohesion}()},
\code{\link{graph_smallworld}()},
\code{\link{node_constraint}()}

Other node-level measures: 
\code{\link{node_constraint}()}
}
\concept{node-level measures}
\concept{two-mode measures}
