% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\alias{project_rows}
\alias{project_cols}
\title{Projecting two-mode objects into one-mode objects}
\usage{
project_rows(object)

project_cols(object)
}
\arguments{
\item{object}{A matrix, \code{igraph} graph or \code{tidygraph} tbl_graph object.}
}
\description{
These functions 'project' or convert a two-mode object
in any format -- tidygraph, igraph, or matrix --
into a corresponding one-mode object.
}
\details{
\code{project_rows()} results in a weighted one-mode object
that retains the row nodes from a two-mode object,
and weights the ties between them on the basis of
their joint ties to nodes in the second mode (columns).

\code{project_cols()} results in a weighted one-mode object
that retains the column nodes from a two-mode object,
and weights the ties between them on the basis of
their joint ties to nodes in the first mode (rows).
}
\examples{
project_rows(southern_women)
project_cols(southern_women)
}
