% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_census.R
\name{network_census}
\alias{network_census}
\alias{network_dyad_census}
\alias{network_triad_census}
\alias{network_mixed_census}
\title{Censuses of motifs at the network level}
\source{
Alejandro Espinosa 'netmem'
}
\usage{
network_dyad_census(object)

network_triad_census(object)

network_mixed_census(object, object2)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{object2}{A second, two-mode migraph-consistent object.}
}
\description{
Censuses of motifs at the network level
}
\section{Functions}{
\itemize{
\item \code{network_dyad_census()}: Returns a census of dyad motifs in a network

\item \code{network_triad_census()}: Returns a census of triad motifs in a network

\item \code{network_mixed_census()}: Returns a census of triad motifs that span
a one-mode and a two-mode network

}}
\examples{
network_dyad_census(ison_algebra)
network_triad_census(ison_adolescents)
marvel_friends <- to_unsigned(ison_marvel_relationships, "positive")
(mixed_cen <- network_mixed_census(marvel_friends, ison_marvel_teams))
}
\references{
Davis, James A., and Samuel Leinhardt. 1967.
“\href{https://files.eric.ed.gov/fulltext/ED024086.pdf}{The Structure of Positive Interpersonal Relations in Small Groups}.” 55.

Hollway, James, Alessandro Lomi, Francesca Pallotti, and Christoph Stadtfeld. 2017.
“Multilevel Social Spaces: The Network Dynamics of Organizational Fields.”
\emph{Network Science} 5(2): 187–212.
\doi{10.1017/nws.2017.8}
}
\seealso{
Other motifs: 
\code{\link{brokerage_census}},
\code{\link{node_census}}
}
\concept{motifs}
