% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/member_components.R
\name{components}
\alias{components}
\alias{node_components}
\alias{node_weak_components}
\alias{node_strong_components}
\alias{node_coreness}
\title{Component partitioning algorithms}
\usage{
node_components(object)

node_weak_components(object)

node_strong_components(object)

node_coreness(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions create a vector of nodes' memberships in
components or degrees of coreness.

In graph theory, components, sometimes called connected components,
are induced subgraphs from partitioning the nodes into disjoint sets.
All nodes that are members of the same partition as \emph{i} are reachable
from \emph{i}.

For directed networks,
strongly connected components consist of subgraphs where there are paths
in each direction between member nodes.
Weakly connected components consist of subgraphs where there is a path
in either direction between member nodes.

Coreness captures the maximal subgraphs in which each vertex has at least
degree \emph{k}, where \emph{k} is also the order of the subgraph.
As described in \code{igraph::coreness},
a node's coreness is \emph{k} if it belongs to the \emph{k}-core
but not to the (\emph{k}+1)-core.
}
\section{Functions}{
\itemize{
\item \code{node_components}: Returns nodes' component membership
using edge direction where available.

\item \code{node_weak_components}: Returns nodes' component membership
ignoring edge direction.

\item \code{node_strong_components}: Returns nodes' component membership
based on edge direction.

\item \code{node_coreness}: Returns k-cores
}}

\examples{
node_components(mpn_bristol)
node_coreness(ison_adolescents)
}
\seealso{
Other membership: 
\code{\link{community}},
\code{\link{equivalence}}
}
\concept{membership}
