% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-use_microservice.R
\name{use_plumber_microservice}
\alias{use_plumber_microservice}
\alias{use_microservice}
\title{Use a plumber Microservice in an R Project}
\usage{
use_plumber_microservice(path = ".", overwrite = FALSE)

use_microservice(path = ".", overwrite = FALSE)
}
\arguments{
\item{path}{(\code{character}) Where is the project root folder?}

\item{overwrite}{(\code{logical}) Should existing destination files be overwritten?}
}
\value{
No return value, called for side effects.
}
\description{
Lay the infrastructure for a microservice. That includes unit test,
dependency packages, configuration file, entrypoints and utility endpoint.
}
\note{
\code{use_plumber_microservice()} and \code{use_microservice()} are synonyms.
}
\examples{
path <- tempfile()
use_plumber_microservice(path)

list.files(path, recursive = TRUE)

cat(read.dcf(file.path(path, "DESCRIPTION"), "Imports"))
cat(read.dcf(file.path(path, "DESCRIPTION"), "Suggests"))
}
\seealso{
Other plumber microservice: 
\code{\link{add_plumber_service}()}
}
\concept{plumber microservice}
