% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasta.R
\name{plot.Fasta}
\alias{plot.Fasta}
\alias{summary.Fasta}
\title{Plotting and summary of \code{Fasta} objects}
\usage{
\method{plot}{Fasta}(x, y = NULL, col = "tan4", border = "tan4", ...)

\method{summary}{Fasta}(object, ...)
}
\arguments{
\item{x}{A \code{Fasta} object, see below.}

\item{y}{not used.}

\item{col}{Color of bar interiors.}

\item{border}{Color of bar borders.}

\item{...}{Optional graphical arguments.}

\item{object}{A \code{Fasta} object, see below.}
}
\description{
Generic functions for plotting and printing the content of a \code{Fasta} object.
}
\details{
A \code{Fasta} object contains biological sequences in the FASTA format. It is a small (S3)
extension to a \code{data.frame}. It is actually a \code{data.frame} containing at least two text columns
named \samp{Header} and \samp{Sequence}. The \samp{Header} column contains the headerlines for each sequence,
and the \samp{Sequence} columns the sequences themselves. A \code{Fasta} object is typically created by reading
a FASTA formatted file into R by \code{\link{readFasta}}.

A \code{Fasta} object can be treated as a \code{data.frame}, which makes it quick and easy to search both
\samp{Header} and \samp{Sequence} for specific regular expressions, sort or re-arrange the ordering of the sequences,
extract subsets or add new data to an existing \code{Fasta} object.

The \code{plot.Fasta} function will display the content of the \code{Fasta} object as a histogram over
the lengths of the sequences.

The \code{summary.Fasta} function will display a text giving the number of sequences and the alphabet,
i.e. listing all unique symbols found in the file.
}
\examples{
# See the examples in the Help-file for readFasta/writeFasta

}
\seealso{
\code{\link{readFasta}}, \code{\link{writeFasta}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
