% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectPkModel.R
\docType{class}
\name{PkData-class}
\alias{PkData-class}
\alias{PkData}
\alias{pkData}
\alias{pkdata}
\title{An S4 object containing samples from a Pk model}
\description{
An S4 object containing samples from a Pk model
}
\section{Slots}{

\describe{
\item{\code{modelFunction}}{a function of parameters and hyperparameters}

\item{\code{parameters}}{a data.frame of parameters of mean parameters as input to the modelFunction
with columns:
    \itemize{
      \item parameter: parameter name for 
      \item explanation: optional explantion
      \item value: fixed parameter value for \code{\link{PkModel-class}},
      for \code{\link{PkModel-class}} split up between \code{minValue} and \code{maxValue}               
      \item coeffVariation: the coefficient of variation (  standard deviation / mean ) specifying between-subject variation,
      for \code{\link{PkModelRange-class}}  split up into \code{minValue} and \code{maxValue}  
    }}

\item{\code{correlationMatrix}}{correlation matrix of parameters at the log-scale}

\item{\code{coeffVariationError}}{the coefficient of variation for residual normally distributed error, 
  for \code{\link{PkModelRange-class}}  split up into \code{minCoeffVariationError} and \code{maxCoeffVariationError} 
@slot dosingInfo data frame containing:
      \itemize{
        \item time numeric,  times when a dose is administered
        \item dose numeric, with an amount of dose 
      }}

\item{\code{timePoints}}{vector of time points}

\item{\code{.Data}}{a numerical array of 3 dimensions ( nSubjects x nTimePoints x nSamples )}
}}

\note{
other slots are inherited from \code{{\link{PkModel-class}}}
}
\author{
Adriaan Blommaert
}
