% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_beta.R
\name{trans_beta}
\alias{trans_beta}
\title{Create \code{trans_beta} object for beta-diversity analysis based on the distance matrix}
\description{
This class is a wrapper for a series of beta-diversity related analysis, 
including ordination calculation and plot based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>, group distance comparision, 
clustering, perMANOVA based on Anderson al. (2008) <doi:10.1111/j.1442-9993.2001.01070.pp.x>, ANOSIM and PERMDISP.
}
\examples{

## ------------------------------------------------
## Method `trans_beta$new`
## ------------------------------------------------

data(dataset)
t1 <- trans_beta$new(dataset = dataset, measure = "bray", group = "Group")

## ------------------------------------------------
## Method `trans_beta$cal_ordination`
## ------------------------------------------------

t1$cal_ordination(ordination = "PCoA")		

## ------------------------------------------------
## Method `trans_beta$plot_ordination`
## ------------------------------------------------

t1$plot_ordination(plot_type = "point")
t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_type = "point")
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "ellipse"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "centroid"), 
	  centroid_segment_linetype = 1)

## ------------------------------------------------
## Method `trans_beta$cal_manova`
## ------------------------------------------------

t1$cal_manova(manova_all = TRUE)

## ------------------------------------------------
## Method `trans_beta$cal_anosim`
## ------------------------------------------------

t1$cal_anosim()

## ------------------------------------------------
## Method `trans_beta$cal_betadisper`
## ------------------------------------------------

t1$cal_betadisper()

## ------------------------------------------------
## Method `trans_beta$cal_group_distance`
## ------------------------------------------------

\donttest{
t1$cal_group_distance(within_group = TRUE)
}

## ------------------------------------------------
## Method `trans_beta$cal_group_distance_diff`
## ------------------------------------------------

\donttest{
t1$cal_group_distance_diff()
}

## ------------------------------------------------
## Method `trans_beta$plot_group_distance`
## ------------------------------------------------

\donttest{
t1$plot_group_distance()
}

## ------------------------------------------------
## Method `trans_beta$plot_clustering`
## ------------------------------------------------

t1$plot_clustering(group = "Group", replace_name = c("Saline", "Type"))
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_beta-new}{\code{trans_beta$new()}}
\item \href{#method-trans_beta-cal_ordination}{\code{trans_beta$cal_ordination()}}
\item \href{#method-trans_beta-plot_ordination}{\code{trans_beta$plot_ordination()}}
\item \href{#method-trans_beta-cal_manova}{\code{trans_beta$cal_manova()}}
\item \href{#method-trans_beta-cal_anosim}{\code{trans_beta$cal_anosim()}}
\item \href{#method-trans_beta-cal_betadisper}{\code{trans_beta$cal_betadisper()}}
\item \href{#method-trans_beta-cal_group_distance}{\code{trans_beta$cal_group_distance()}}
\item \href{#method-trans_beta-cal_group_distance_diff}{\code{trans_beta$cal_group_distance_diff()}}
\item \href{#method-trans_beta-plot_group_distance}{\code{trans_beta$plot_group_distance()}}
\item \href{#method-trans_beta-plot_clustering}{\code{trans_beta$plot_clustering()}}
\item \href{#method-trans_beta-clone}{\code{trans_beta$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$new(dataset = NULL, measure = NULL, group = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} class.}

\item{\code{measure}}{default NULL; bray, jaccard, wei_unifrac or unwei_unifrac, or other name of matrix stored in \code{microtable$beta_diversity}; 
used for ordination, manova, group distance comparision, etc. The measure must be one of names in \code{microtable$beta_diversity} list. 
Please see \code{cal_betadiv} function of \code{\link{microtable}} class for more details.}

\item{\code{group}}{default NULL; sample group used for manova, betadisper or group distance comparision.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
parameters stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
t1 <- trans_beta$new(dataset = dataset, measure = "bray", group = "Group")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-cal_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-cal_ordination}{}}}
\subsection{Method \code{cal_ordination()}}{
Unconstrained ordination.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_ordination(
  ordination = "PCoA",
  ncomp = 3,
  trans_otu = FALSE,
  scale_species = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ordination}}{default "PCoA"; "PCA", "PCoA" or "NMDS". PCA: principal component analysis; 
PCoA: principal coordinates analysis; NMDS: non-metric multidimensional scaling.}

\item{\code{ncomp}}{default 3; dimensions needed in the result.}

\item{\code{trans_otu}}{default FALSE; whether species abundance will be square transformed; only available when \code{ordination = PCA}.}

\item{\code{scale_species}}{default FALSE; whether species loading in PCA will be scaled.}

\item{\code{...}}{parameters passed to \code{vegan::rda} function when ordination = "PCA", or \code{ape::pcoa} function when ordination = "PCoA", 
or \code{vegan::metaMDS} function when when ordination = "NMDS".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_ordination} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_ordination(ordination = "PCoA")		
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-plot_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-plot_ordination}{}}}
\subsection{Method \code{plot_ordination()}}{
Plot the ordination result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$plot_ordination(
  plot_type = "point",
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  shape_values = c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14),
  plot_color = NULL,
  plot_shape = NULL,
  plot_group_order = NULL,
  add_sample_label = NULL,
  point_size = 3,
  point_alpha = 0.8,
  centroid_segment_alpha = 0.6,
  centroid_segment_size = 1,
  centroid_segment_linetype = 3,
  ellipse_chull_fill = TRUE,
  ellipse_chull_alpha = 0.1,
  ellipse_level = 0.9,
  ellipse_type = "t",
  NMDS_stress_pos = c(1, 1),
  NMDS_stress_text_prefix = ""
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_type}}{default "point"; one or more elements of "point", "ellipse", "chull" and "centroid".
\describe{
  \item{\strong{'point'}}{add point}
  \item{\strong{'ellipse'}}{add confidence ellipse for points of each group}
  \item{\strong{'chull'}}{add convex hull for points of each group}
  \item{\strong{'centroid'}}{add centroid line of each group}
}}

\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for different groups.}

\item{\code{shape_values}}{default c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14); a vector for point shape types of groups, see \code{ggplot2} tutorial.}

\item{\code{plot_color}}{default NULL; a colname of \code{sample_table} to assign colors to different groups in plot.}

\item{\code{plot_shape}}{default NULL; a colname of \code{sample_table} to assign shapes to different groups in plot.}

\item{\code{plot_group_order}}{default NULL; a vector used to order the groups in the legend of plot.}

\item{\code{add_sample_label}}{default NULL; a column name in \code{sample_table}; If provided, show the point name in plot.}

\item{\code{point_size}}{default 3; point size when "point" is in \code{plot_type} parameter.}

\item{\code{point_alpha}}{default .8; point transparency in plot when "point" is in \code{plot_type} parameter.}

\item{\code{centroid_segment_alpha}}{default 0.6; segment transparency in plot when "centroid" is in \code{plot_type} parameter.}

\item{\code{centroid_segment_size}}{default 1; segment size in plot when "centroid" is in \code{plot_type} parameter.}

\item{\code{centroid_segment_linetype}}{default 3; the line type related with centroid in plot when "centroid" is in \code{plot_type} parameter.}

\item{\code{ellipse_chull_fill}}{default TRUE; whether fill colors to the area of ellipse or chull.}

\item{\code{ellipse_chull_alpha}}{default 0.1; color transparency in the ellipse or convex hull depending on whether "ellipse" or "centroid" is in \code{plot_type} parameter.}

\item{\code{ellipse_level}}{default .9; confidence level of ellipse when "ellipse" is in \code{plot_type} parameter.}

\item{\code{ellipse_type}}{default "t"; ellipse type when "ellipse" is in \code{plot_type} parameter; see type in \code{\link{stat_ellipse}}.}

\item{\code{NMDS_stress_pos}}{default c(1, 1); a numerical vector with two values used to represent the insertion position of the stress text. 
The first one denotes the x-axis, while the second one corresponds to the y-axis. 
The assigned position is determined by multiplying the respective value with the maximum point on the corresponding coordinate axis. 
Thus, the x-axis position is equal to \code{max(points of x axis) * NMDS_stress_pos[1]}, 
and the y-axis position is equal to \code{max(points of y axis) * NMDS_stress_pos[2]}. Negative values can also be utilized for the negative part of the axis.
\code{NMDS_stress_pos = NULL} denotes no stress text to show.}

\item{\code{NMDS_stress_text_prefix}}{default ""; If NMDS_stress_pos is not NULL, this parameter can be used to add text in front of the stress value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$plot_ordination(plot_type = "point")
t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_type = "point")
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "ellipse"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "centroid"), 
	  centroid_segment_linetype = 1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-cal_manova"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-cal_manova}{}}}
\subsection{Method \code{cal_manova()}}{
Calculate perMANOVA based on <doi:10.1111/j.1442-9993.2001.01070.pp.x> and R vegan \code{adonis2} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_manova(
  manova_all = TRUE,
  manova_set = NULL,
  group = NULL,
  p_adjust_method = "fdr",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{manova_all}}{default TRUE; TRUE represents test for all the groups, i.e. the overall test;
FALSE represents test for all the paired groups.}

\item{\code{manova_set}}{default NULL; other specified group set for manova, such as \code{"Group + Type"} and \code{"Group*Type"}; see also \code{\link{adonis2}}.
manova_set has higher priority than manova_all parameter. If manova_set is provided; manova_all is disabled.}

\item{\code{group}}{default NULL; a column name of \code{sample_table} used for manova. If NULL, search \code{group} variable stored in the object.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; available when \code{manova_all = FALSE}; see method parameter of \code{p.adjust} function for available options.}

\item{\code{...}}{parameters passed to \code{\link{adonis2}} function of \code{vegan} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_manova} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_manova(manova_all = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-cal_anosim"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-cal_anosim}{}}}
\subsection{Method \code{cal_anosim()}}{
Analysis of similarities (ANOSIM) based on R vegan \code{anosim} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_anosim(
  group = NULL,
  paired = FALSE,
  p_adjust_method = "fdr",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{default NULL; a column name of \code{sample_table}. If NULL, search \code{group} variable stored in the object.}

\item{\code{paired}}{default FALSE; whether perform paired test between any two combined groups from all the input groups.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; available when \code{paired = TRUE}; see method parameter of \code{p.adjust} function for available options.}

\item{\code{...}}{parameters passed to \code{\link{anosim}} function of \code{vegan} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_anosim} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_anosim()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-cal_betadisper"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-cal_betadisper}{}}}
\subsection{Method \code{cal_betadisper()}}{
A wrapper for \code{betadisper} function in vegan package for multivariate homogeneity test of groups dispersions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_betadisper(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to \code{\link{betadisper}} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_betadisper} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_betadisper()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-cal_group_distance"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-cal_group_distance}{}}}
\subsection{Method \code{cal_group_distance()}}{
Convert sample distances within groups or between groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_group_distance(
  within_group = TRUE,
  by_group = NULL,
  ordered_group = NULL,
  sep = " vs "
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{within_group}}{default TRUE; whether transform sample distance within groups, if FALSE, transform sample distance between any two groups.}

\item{\code{by_group}}{default NULL; one colname name of sample_table in \code{microtable} object.
If provided, transform distances by the provided by_group parameter. This is especially useful for ordering and filtering values further.
When \code{within_group = TRUE}, the result of by_group parameter is the format of paired groups.
When \code{within_group = FALSE}, the result of by_group parameter is the format same with the group information in \code{sample_table}.}

\item{\code{ordered_group}}{default NULL; a vector representing the ordered elements of \code{group} parameter; only useful when within_group = FALSE.}

\item{\code{sep}}{default TRUE; a character string to separate the group names after merging them into a new name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_group_distance} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_group_distance(within_group = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-cal_group_distance_diff"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-cal_group_distance_diff}{}}}
\subsection{Method \code{cal_group_distance_diff()}}{
Differential test of distances among groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$cal_group_distance_diff(
  group = NULL,
  by_group = NULL,
  by_ID = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{default NULL; a column name of \code{object$res_group_distance} used for the statistics; If NULL, use the \code{group} inside the object.}

\item{\code{by_group}}{default NULL; a column of \code{object$res_group_distance} used to perform the differential test 
among elements in \code{group} parameter for each element in \code{by_group} parameter. So \code{by_group} has a larger scale than \code{group} parameter.
This \code{by_group} is very different from the \code{by_group} parameter in the \code{cal_group_distance} function.}

\item{\code{by_ID}}{default NULL; a column of \code{object$res_group_distance} used to perform paired t test or paired wilcox test for the paired data,
such as the data of plant compartments for different plant species (ID). 
So \code{by_ID} should be the smallest unit of sample collection without any repetition in it.}

\item{\code{...}}{parameters passed to \code{cal_diff} function of \code{\link{trans_alpha}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_group_distance_diff} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_group_distance_diff()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-plot_group_distance"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-plot_group_distance}{}}}
\subsection{Method \code{plot_group_distance()}}{
Plotting the distance between samples within or between groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$plot_group_distance(plot_group_order = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_group_order}}{default NULL; a vector used to order the groups in the plot.}

\item{\code{...}}{parameters (except measure) passed to \code{plot_alpha} function of \code{\link{trans_alpha}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_group_distance()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-plot_clustering"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-plot_clustering}{}}}
\subsection{Method \code{plot_clustering()}}{
Plotting clustering result based on the \code{ggdendro} package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$plot_clustering(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  measure = NULL,
  group = NULL,
  replace_name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); color palette for the text.}

\item{\code{measure}}{default NULL; beta diversity index; If NULL, using the measure when creating object}

\item{\code{group}}{default NULL; if provided, use this group to assign color.}

\item{\code{replace_name}}{default NULL; if provided, use this as label.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$plot_clustering(group = "Group", replace_name = c("Saline", "Type"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_beta-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_beta-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_beta$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
