% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MoPPro.R
\name{MoPPro}
\alias{MoPPro}
\title{Estimation of metabolic profile(s) based on Taxy-Pro predictions from whole metagenome shotgun data}
\usage{
MoPPro(MoPProInput, folderReferenceData)
}
\arguments{
\item{MoPProInput}{(required): list containing the taxonomic profile and sample name(s), e.g. imported with the function \code{\link{importTaxyProData}}.}

\item{folderReferenceData}{(required): a character vector with one character string indicating the folder location of the unzipped reference data.}
}
\value{
A vector/matrix containing the estimated metabolic profile(s)
}
\description{
Estimation of metabolic profile(s) based on Taxy-Pro predictions from whole metagenome shotgun data
}
\details{
MoP-Pro, a mixture model-based approach for the estimation of pathway abundances, provides a basis for statistical interpretation and fast computation of metabolic profiles of metagenomes.
To overcome computationally intense homology searches, MoP-Pro implements a shortcut to estimate the metabolic profile of a metagenome.
The taxonomic profile of the metagenome is linked to a set of pre-computed metabolic reference profiles.
The combination of the taxonomic abundance estimates, obtained through the fast method Taxy-Pro, and the
metabolic reference profiles, based on the KEGG database, achieves an unrivaled speed of the metabolic profiling approach.
}
\author{
Kathrin P. Asshauer \email{kathrin@gobics.de}
}
\references{
\url{http://drops.dagstuhl.de/opus/volltexte/2013/4238/pdf/p001-asshauer.pdf}
}

