% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada2.R
\name{processSeq}
\alias{processSeq}
\title{Perform dada2 analysis}
\usage{
processSeq(
  path = ".",
  truncLen = c(0, 0),
  trimLeft = 0,
  trimRight = 0,
  minLen = 20,
  maxLen = Inf,
  sample_info = NULL,
  train_data = "silva_nr99_v138_train_set.fa.gz",
  train_species = "silva_species_assignment_v138.fa.gz",
  outpath = NULL,
  saveobj = FALSE,
  buildtree = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{working dir for the input reads}

\item{truncLen}{(Optional). Default 0 (no truncation). Truncate reads after truncLen bases. Reads shorter than this are discarded.}

\item{trimLeft}{(Optional). The number of nucleotides to remove from the start of each read.}

\item{trimRight}{(Optional). Default 0. The number of nucleotides to remove from the end of each read.
If both truncLen and trimRight are provided, truncation will be performed after trimRight is enforced.}

\item{minLen}{(Optional). Default 20. Remove reads with length less than minLen. minLen is enforced after trimming and truncation.}

\item{maxLen}{Optional). Default Inf (no maximum). Remove reads with length greater than maxLen. maxLen is enforced before trimming and truncation.}

\item{sample_info}{(Optional).sample information for the sequence}

\item{train_data}{(Required).training database}

\item{train_species}{(Required). species database}

\item{outpath}{(Optional).the path for the filtered reads and th out table}

\item{saveobj}{(Optional).Default FALSE. save the phyloseq object output.}

\item{buildtree}{build phylogenetic tree or not(default: FALSE)}

\item{verbose}{(Optional). Default TRUE. Print verbose text output.}
}
\value{
list include count table, summary table, taxonomy information and phyloseq object
}
\description{
Perform dada2 analysis
}
\author{
Kai Guo
}
