% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilitas.R
\name{stabilitas}
\alias{stabilitas}
\title{Extract the stability results of individuals from the output of \code{\link[=iterative_clustering]{iterative_clustering()}}.}
\usage{
stabilitas(klist, common)
}
\arguments{
\item{klist}{input list corresponding to the output of \code{\link[=iterative_clustering]{iterative_clustering()}}.}

\item{common}{pattern that separates the ID and the sampling time.}
}
\value{
µSTASIS stability score (mS) for the individuals from the two selected sampling times.
}
\description{
Those individuals whose samples are clustered under the same label in list\verb{[[x]]}$cluster sum 1. If samples are in different clusters sum 0. Then, this is done for all possible values of k and, finally, divided the sum by k, so obtaining a value between 0 and 1.
}
\examples{
t1_t2 <- paired_times(data = clr[,1:50], first = "_1",
                      second = "_25", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
}
