% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radarPC.R
\name{radarPC}
\alias{radarPC}
\title{Plot a radar chart of paired samples from one individual or from different groups.}
\usage{
radarPC(
  data,
  samples = c(1, 2),
  pre_radar = pre_radar,
  legend = expression("t"[1], "t"[2]),
  colors = c("orange", "royalblue"),
  groups = NULL,
  fun = "mean"
)
}
\arguments{
\item{data}{input matrix with paired times.}

\item{samples}{position of the samples from an individual to be plotted.}

\item{pre_radar}{list; the output from \code{\link[=pre_radarPC]{pre_radarPC()}}.}

\item{legend}{text to plot.}

\item{colors}{specify desired colors.}

\item{groups}{vector with the same length as the number of rows in the \code{\link[=st_previz]{st_previz()}} output.}

\item{fun}{character: mean or median; if the lines should correspond to any of those statistics when adding a groups vector.}
}
\value{
A radar chart (or spider plot) of the principal components for two samples from the same individual or for two groups.
}
\description{
Plot a radar chart of paired samples from one individual or from different groups.
}
\examples{
t1_t2 <- paired_times(data = clr[,1:25], first = "_1",
                      second = "_25", common = "_0_")
t2_t3 <- paired_times(data = clr[,1:25], first = "_25",
                      second = "_26", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
klist_t2_t3 <- iterative_clustering(data = t2_t3, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
result_t2_t3 <- stabilitas(klist_t2_t3, common = "_0_")
results <- st_previz(results = list(result_t1_t2, result_t2_t3),
                     times = c("t1_t2", "t2_t3"))
pre_radar <- pre_radarPC(data = t1_t2, exp.var = 0.85)
radarPC(data = t1_t2, samples = c(3,4), pre_radar = pre_radar, colors = c(1,2))
metadata <- data.frame(Sample = rownames(clr),
                       age = c(rep("youth", 65), rep("old", 131-65)))
group <- metadata_groups(metadata = metadata, samples = metadata$Sample,
                         individuals = results$individual, col_number = 2)
radarPC(data = t1_t2, pre_radar = pre_radar, groups = rep(group, each = 2),
        colors = c("cyan1", "cyan3", "brown1", "brown3"))
}
