% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice-package.R, R/mice.r
\docType{package}
\name{mice}
\alias{mice}
\alias{mice-package}
\alias{mice}
\title{\pkg{mice}: Multivariate Imputation by Chained Equations}
\usage{
mice(data, m = 5, method = vector("character", length = ncol(data)),
  predictorMatrix = (1 - diag(1, ncol(data))), where = is.na(data),
  visitSequence = NULL, form = vector("character", length = ncol(data)),
  post = vector("character", length = ncol(data)), defaultMethod = c("pmm",
  "logreg", "polyreg", "polr"), maxit = 5, diagnostics = TRUE,
  printFlag = TRUE, seed = NA, imputationMethod = NULL,
  defaultImputationMethod = NULL, data.init = NULL, ...)
}
\arguments{
\item{data}{A data frame or a matrix containing the incomplete data.  Missing
values are coded as \code{NA}.}

\item{m}{Number of multiple imputations. The default is \code{m=5}.}

\item{method}{Can be either a single string, or a vector of strings with
length \code{ncol(data)}, specifying the univariate imputation method to be
used for each column in data. If specified as a single string, the same
method will be used for all columns.  The default imputation method (when no
argument is specified) depends on the measurement level of the target column
and are specified by the \code{defaultMethod} argument.  Columns that need
not be imputed have the empty method \code{''}.  See details for more
information.}

\item{predictorMatrix}{A square matrix of size \code{ncol(data)} containing
0/1 data specifying the set of predictors to be used for each target column.
Rows correspond to target variables (i.e. variables to be imputed), in the
sequence as they appear in data. A value of '1' means that the column
variable is used as a predictor for the target variable (in the rows). The
diagonal of \code{predictorMatrix} must be zero. The default for
\code{predictorMatrix} is that all other columns are used as predictors
(sometimes called massive imputation). Note: For two-level imputation codes
'2' and '-2' are also allowed.}

\item{where}{A data frame or matrix with logicals of the same dimensions 
as \code{data} indicating where in the data the imputations should be 
created. The default, \code{where = is.na(data)}, specifies that the
missing data should be imputed. The \code{where} argument may be used to 
overimpute observed data, or to skip imputations for selected missing values.}

\item{visitSequence}{A vector of integers of arbitrary length, specifying the
column indices of the visiting sequence. The visiting sequence is the column
order that is used to impute the data during one pass through the data. A
column may be visited more than once. All incomplete columns that are used as
predictors should be visited, or else the function will stop with an error.
The default sequence \code{1:ncol(data)} implies that columns are imputed
from left to right. It is possible to specify one of the keywords
\code{'roman'} (left to right), \code{'arabic'} (right to left),
\code{'monotone'} (sorted in increasing amount of missingness) and
\code{'revmonotone'} (reverse of monotone). The keyword should be supplied as
a string and may be abbreviated.}

\item{form}{A vector of strings with length \code{ncol(data)}, specifying
formulae. Each string is parsed and executed within the \code{sampler()}
function to create terms for the predictor.  The default is to do nothing,
indicated by a vector of empty strings \code{''}.  The main value
lies in the easy specification of interaction terms.  The user must
ensure that the set of variables in the formula match those in
\code{predictors}.}

\item{post}{A vector of strings with length \code{ncol(data)}, specifying
expressions. Each string is parsed and executed within the \code{sampler()}
function to postprocess imputed values.  The default is to do nothing,
indicated by a vector of empty strings \code{''}.}

\item{defaultMethod}{A vector of three strings containing the default
imputation methods for numerical columns, factor columns with 2 levels, and
columns with (unordered or ordered) factors with more than two levels,
respectively. If nothing is specified, the following defaults will be used:
\code{pmm}, predictive mean matching (numeric data) \code{logreg}, logistic
regression imputation (binary data, factor with 2 levels) \code{polyreg},
polytomous regression imputation for unordered categorical data (factor >= 2
levels) \code{polr}, proportional odds model for (ordered, >= 2 levels)}

\item{maxit}{A scalar giving the number of iterations. The default is 5.}

\item{diagnostics}{A Boolean flag. If \code{TRUE}, diagnostic information
will be appended to the value of the function. If \code{FALSE}, only the
imputed data are saved. The default is \code{TRUE}.}

\item{printFlag}{If \code{TRUE}, \code{mice} will print history on console.
Use \code{print=FALSE} for silent computation.}

\item{seed}{An integer that is used as argument by the \code{set.seed()} for
offsetting the random number generator. Default is to leave the random number
generator alone.}

\item{imputationMethod}{Same as \code{method} argument. Included for
backwards compatibility.}

\item{defaultImputationMethod}{Same as \code{defaultMethod} argument.
Included for backwards compatibility.}

\item{data.init}{A data frame of the same size and type as \code{data},
without missing data, used to initialize imputations before the start of the
iterative process.  The default \code{NULL} implies that starting imputation
are created by a simple random draw from the data. Note that specification of
\code{data.init} will start the \code{m} Gibbs sampling streams from the same
imputations.}

\item{...}{Named arguments that are passed down to the univariate imputation
functions.}
}
\value{
Returns an S3 object of class \code{\link[=mids-class]{mids}}
       (multiply imputed data set)
}
\description{
The \pkg{mice} package implements a method to deal with missing data. 
The package creates multiple imputations (replacement values) for 
multivariate missing data. The method is based on Fully Conditional 
Specification, where each incomplete variable is imputed by a separate 
model. The MICE algorithm can impute mixes of continuous, binary, 
unordered categorical and ordered categorical data. In addition, MICE 
can impute continuous two-level data, and maintain consistency between 
imputations by means of passive imputation. Many diagnostic plots are 
implemented to inspect the quality of the imputations.

Generates Multivariate Imputations by Chained Equations (MICE)
}
\details{
The \pkg{mice} package contains functions to 
\itemize{
\item Inspect the missing data pattern
\item Impute the missing data \emph{m} times, resulting in \emph{m} completed data sets
\item Diagnose the quality of the imputed values
\item Analyze each completed data set
\item Pool the results of the repeated analyses
\item Store and export the imputed data in various formats
\item Generate simulated incomplete data
\item Incorporate custom imputation methods
}

Generates multiple imputations for incomplete multivariate data by Gibbs
sampling. Missing data can occur anywhere in the data. The algorithm imputes
an incomplete column (the target column) by generating 'plausible' synthetic
values given other columns in the data. Each incomplete column must act as a
target column, and has its own specific set of predictors. The default set of
predictors for a given target consists of all other columns in the data. For
predictors that are incomplete themselves, the most recently generated
imputations are used to complete the predictors prior to imputation of the
target column.

A separate univariate imputation model can be specified for each column. The
default imputation method depends on the measurement level of the target
column. In addition to these, several other methods are provided. You can
also write their own imputation functions, and call these from within the
algorithm.

The data may contain categorical variables that are used in a regressions on
other variables. The algorithm creates dummy variables for the categories of
these variables, and imputes these from the corresponding categorical
variable. The extended model containing the dummy variables is called the
padded model. Its structure is stored in the list component \code{pad}.

Built-in univariate imputation methods are:

\tabular{lll}{
\code{pmm}          \tab any     \tab Predictive mean matching\cr
\code{midastouch}   \tab any     \tab Weighted predictive mean matching\cr
\code{sample}       \tab any     \tab Random sample from observed values\cr
\code{cart}         \tab any     \tab Classification and regression trees\cr
\code{rf}           \tab any     \tab Random forest imputations\cr
\code{mean}         \tab numeric \tab Unconditional mean imputation\cr
\code{norm}         \tab numeric \tab Bayesian linear regression\cr
\code{norm.nob}     \tab numeric \tab Linear regression ignoring model error\cr
\code{norm.boot}    \tab numeric \tab Linear regression using bootstrap\cr
\code{norm.predict} \tab numeric \tab Linear regression, predicted values\cr
\code{quadratic}    \tab numeric \tab Imputation of quadratic terms\cr
\code{ri}           \tab numeric \tab Random indicator for nonignorable data\cr
\code{logreg}       \tab binary  \tab Logistic regression\cr
\code{logreg.boot}  \tab binary  \tab Logistic regression with bootstrap\cr
\code{polr}         \tab ordered \tab Proportional odds model\cr
\code{polyreg}      \tab unordered\tab Polytomous logistic regression\cr
\code{lda}          \tab unordered\tab Linear discriminant analysis\cr
\code{2l.norm}      \tab numeric  \tab Level-1 normal heteroskedastic\cr
\code{2l.lmer}      \tab numeric  \tab Level-1 normal homoscedastic, lmer\cr
\code{2l.pan}       \tab numeric  \tab Level-1 normal homoscedastic, pan\cr
\code{2lonly.mean}  \tab numeric  \tab Level-2 class mean\cr
\code{2lonly.norm}  \tab numeric  \tab Level-2 class normal\cr
\code{2lonly.pmm}   \tab any      \tab Level-2 class predictive mean matching
}

These corresponding functions are coded in the \code{mice} library under
names \code{mice.impute.method}, where \code{method} is a string with the
name of the univariate imputation method name, for example \code{norm}. The
\code{method} argument specifies the methods to be used.  For the \code{j}'th
column, \code{mice()} calls the first occurence of
\code{paste('mice.impute.', method[j], sep = '')} in the search path.  The
mechanism allows uses to write customized imputation function,
\code{mice.impute.myfunc}. To call it for all columns specify
\code{method='myfunc'}.  To call it only for, say, column 2 specify
\code{method=c('norm','myfunc','logreg',\dots{})}.

\emph{Passive imputation:} \code{mice()} supports a special built-in method,
called passive imputation. This method can be used to ensure that a data
transform always depends on the most recently generated imputations.  In some
cases, an imputation model may need transformed data in addition to the
original data (e.g. log, quadratic, recodes, interaction, sum scores, and so
on).

Passive imputation maintains consistency among different transformations of
the same data. Passive imputation is invoked if \code{~} is specified as the
first character of the string that specifies the univariate method.
\code{mice()} interprets the entire string, including the \code{~} character,
as the formula argument in a call to \code{model.frame(formula,
data[!r[,j],])}. This provides a simple mechanism for specifying determinstic
dependencies among the columns. For example, suppose that the missing entries
in variables \code{data$height} and \code{data$weight} are imputed. The body
mass index (BMI) can be calculated within \code{mice} by specifying the
string \code{'~I(weight/height^2)'} as the univariate imputation method for
the target column \code{data$bmi}.  Note that the \code{~} mechanism works
only on those entries which have missing values in the target column. You
should make sure that the combined observed and imputed parts of the target
column make sense. An easy way to create consistency is by coding all entries
in the target as \code{NA}, but for large data sets, this could be
inefficient.  Note that you may also need to adapt the default
\code{predictorMatrix} to evade linear dependencies among the predictors that
could cause errors like \code{Error in solve.default()} or \code{Error:
system is exactly singular}. Though not strictly needed, it is often useful
to specify \code{visitSequence} such that the column that is imputed by the
\code{~} mechanism is visited each time after one of its predictors was
visited. In that way, deterministic relation between columns will always be
synchronized.
}
\section{Functions}{


The main functions are:
\tabular{ll}{
  \code{mice()} \tab Impute the missing data *m* times\cr
  \code{with()} \tab Analyze completed data sets\cr
  \code{pool()} \tab Combine parameter estimates\cr
  \code{complete()} \tab Export imputed data\cr
  \code{ampute()} \tab Generate missing data\cr}
}

\section{Vignettes}{


There is a detailed series of 
six online vignettes that walk you through solving realistic inference 
problems with mice.

We suggest going through these vignettes in the following order
\enumerate{
\item \href{https://gerkovink.github.io/miceVignettes/Ad_hoc_and_mice/Ad_hoc_methods.html}{Ad hoc methods and the MICE algorithm}
\item \href{https://gerkovink.github.io/miceVignettes/Convergence_pooling/Convergence_and_pooling.html}{Convergence and pooling}
\item \href{https://gerkovink.github.io/miceVignettes/Missingness_inspection/Missingness_inspection.html}{Inspecting how the observed data and missingness are related}
\item \href{https://gerkovink.github.io/miceVignettes/Passive_Post_processing/Passive_imputation_post_processing.html}{Passive imputation and post-processing}
\item \href{https://gerkovink.github.io/miceVignettes/Multi_level/Multi_level_data.html}{Imputing multilevel data}
\item \href{https://gerkovink.github.io/miceVignettes/Sensitivity_analysis/Sensitivity_analysis.html}{Sensitivity analysis with \pkg{mice}}
}

The book \emph{Flexible Imputation of Missing Data} contains a lot 
of \href{http://www.stefvanbuuren.nl/mi/FIMD.html}{example code}.
}

\section{Methodology}{


The \pkg{mice} software was published in the \href{https://www.jstatsoft.org/article/view/v045i03}{Journal of Statistical Software} (Van Buuren and Groothuis-Oudshoorn, 2011). 
The first application of the method 
concerned missing blood pressure data (Van Buuren et. al., 1999). 
The term \emph{Fully Conditional Specification} was introduced in 2006 to describe a general class of methods that specify imputations model for multivariate data as a set of conditional distributions (Van Buuren et. al., 2006). Further details on mixes of variables and applications can be found in the book \href{https://www.crcpress.com/Flexible-Imputation-of-Missing-Data/van-Buuren/p/book/9781439868249}{\emph{Flexible Imputation of Missing Data}}.
}

\examples{


# do default multiple imputation on a numeric matrix
imp <- mice(nhanes)
imp

# list the actual imputations for BMI
imp$imp$bmi

# first completed data matrix
complete(imp)


# imputation on mixed data with a different method per column

mice(nhanes2, meth=c('sample','pmm','logreg','norm'))

}
\references{
van Buuren, S., Boshuizen, H.C., Knook, D.L. (1999) Multiple
imputation of missing blood pressure covariates in survival analysis.
\emph{Statistics in Medicine}, \bold{18}, 681--694.

van Buuren, S., Brand, J.P.L., Groothuis-Oudshoorn C.G.M., Rubin, D.B. (2006)
Fully conditional specification in multivariate imputation.  \emph{Journal of
Statistical Computation and Simulation}, \bold{76}, 12, 1049--1064.

van Buuren, S., Groothuis-Oudshoorn, K. (2011). \href{http://www.jstatsoft.org/v45/i03/}{\code{mice}:
Multivariate Imputation by Chained Equations in \code{R}}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1--67.

van Buuren, S. (2012). \href{https://www.crcpress.com/Flexible-Imputation-of-Missing-Data/van-Buuren/p/book/9781439868249}{\emph{Flexible Imputation of Missing Data}}. Chapman & Hall/CRC.

Van Buuren, S., Groothuis-Oudshoorn, K. (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\url{http://www.jstatsoft.org/v45/i03/}

van Buuren, S. (2012). \emph{Flexible Imputation of Missing Data.} Boca
Raton, FL: Chapman & Hall/CRC Press.

Van Buuren, S., Brand, J.P.L., Groothuis-Oudshoorn C.G.M., Rubin, D.B. (2006)
Fully conditional specification in multivariate imputation.  \emph{Journal of
Statistical Computation and Simulation}, \bold{76}, 12, 1049--1064.

Van Buuren, S. (2007) Multiple imputation of discrete and continuous data by
fully conditional specification.  \emph{Statistical Methods in Medical
Research}, \bold{16}, 3, 219--242.

Van Buuren, S., Boshuizen, H.C., Knook, D.L. (1999) Multiple imputation of
missing blood pressure covariates in survival analysis.  \emph{Statistics in
Medicine}, \bold{18}, 681--694.

Brand, J.P.L. (1999) \emph{Development, implementation and evaluation of
multiple imputation strategies for the statistical analysis of incomplete
data sets.} Dissertation. Rotterdam: Erasmus University.
}
\seealso{
\code{\link{mice}}, \code{\link{with.mids}},
\code{\link{pool}}, \code{\link{complete}}, \code{\link{ampute}}

\code{\link[=mids-class]{mids}}, \code{\link{with.mids}},
\code{\link{set.seed}}, \code{\link{complete}}
}
\author{
Stef van Buuren \email{stef.vanbuuren@tno.nl}, Karin
Groothuis-Oudshoorn \email{c.g.m.oudshoorn@utwente.nl}, 2000-2010, with
contributions of Alexander Robitzsch, Gerko Vink, Shahab Jolani, 
Roel de Jong, Jason Turner, Lisa Doove, 
John Fox, Frank E. Harrell, and Peter Malewski.
}
\keyword{iteration}
