% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.dars.R
\name{mica.dar}
\alias{mica.dar}
\title{Get a data access request}
\usage{
mica.dar(mica, id)
}
\arguments{
\item{mica}{A Mica object}

\item{id}{Data access request identifier}
}
\description{
Get a specific data access request.
}
\examples{
\dontrun{
m <- mica.login("someuser", "somepassword", "https://mica-demo.obiba.org")
mica.dar(m, "12345")
mica.logout(m)
}
}
\seealso{
Other data access requests functions: \code{\link{mica.dar.actions}},
  \code{\link{mica.dar.amendment.form}},
  \code{\link{mica.dar.amendment.history}},
  \code{\link{mica.dar.amendments.history}},
  \code{\link{mica.dar.amendments}},
  \code{\link{mica.dar.amendment}},
  \code{\link{mica.dar.form}},
  \code{\link{mica.dar.history}}, \code{\link{mica.dars}}
}
\concept{data access requests functions}
