% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin2wt_all.R
\name{rubin2wt.all}
\alias{rubin2wt.all}
\title{2nd Rubin's rule Within-Variance Component (all peptides)}
\usage{
rubin2wt.all(
  data,
  funcvar = mi4p::within_variance_comp_emmeans,
  metacond,
  is.parallel = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{dataset}

\item{funcvar}{function that should be used to compute the variance}

\item{metacond}{a factor to specify the groups}

\item{is.parallel}{should parallel computing be used?}

\item{verbose}{should messages be displayed?}
}
\value{
List of variance-covariance matrices.
}
\description{
Computes the within-variance component in the 2nd Rubin's rule for all peptides.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], 
conditions = attr(datasim,"metadata")$Condition, method = "MLE")
rubin2wt.all(datasim_imp[1:5,,],funcvar = within_variance_comp_emmeans,
attr(datasim,"metadata")$Condition)
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
\author{
Frédéric Bertrand
}
