% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgss_main.R
\name{estimate_trace}
\alias{estimate_trace}
\title{Trace estimation of the hat matrix.}
\usage{
estimate_trace(m, q, lambda, X, pen_type = "curve", l = NULL, n_random = 5)
}
\arguments{
\item{m}{Vector of non-negative integers. Each entry gives the number of inner knots for the respective covariate.}

\item{q}{Vector of positive integers. Each entry gives the spline degree for the respective covariate.}

\item{lambda}{Positive number as weight for the penalty term.}

\item{X}{Matrix containing the covariates as columns and the units as rows.}

\item{pen_type}{Utilized penalization method. Either \code{"curve"} for the curvature penalty or \code{"diff"} for the difference penalty. Defaults to \code{"curve"}.}

\item{l}{Positive integer vector of length \code{P} indicating for the penalty degree. Only required if \code{pen_type = "diff"}.}

\item{n_random}{Positive integer for the number of random vectors in the trace estimate. Defaults to \code{5}.}
}
\value{
An estimate of the trace of the hat-matrix.
}
\description{
Estimates the trace of the (unknown) hat-matrix by stochastic estimation in a matrix-free manner.
}
\examples{
data <- generate_test_data(100, 2)
X <- data$X_train
estimate_trace(m = c(7,7), q = c(2,2), lambda = 0.1, X = X)

}
