% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check1D.R
\name{check1D}
\alias{check1D}
\title{Checking GAM residuals along one covariate}
\usage{
check1D(o, x, type = "auto", maxpo = 10000, na.rm = TRUE)
}
\arguments{
\item{o}{an object of class \code{gamViz}.}

\item{x}{should be either a single character or a numeric vector.
In the first case it should be the name of one of the variables in the dataframe used to fit \code{o}.
In the second case the length of \code{x} should be equal to the length of \code{residuals(o)}.}

\item{type}{the type of residuals to be used. See \link{residuals.gamViz}.}

\item{maxpo}{maximum number of residuals points that will be used by layers such as
\code{resRug()} and \code{resPoints()}. If number of datapoints > \code{maxpo},
then a subsample of \code{maxpo} points will be taken.}

\item{na.rm}{if \code{TRUE} missing cases in \code{x} or \code{y} will be dropped out.}
}
\value{
An object of class \code{c("plotSmooth", "gg")}.
}
\description{
This function extracts the residuals of a fitted GAM model, and orders
them according to the value of a single covariate. Then several visual residuals diagnostics
can be plotted by adding layers.
}
\examples{
### Example 1: diagnosing heteroscedasticity
library(mgcViz);
set.seed(4124)
n <- 1e4
x <- rnorm(n); y <- rnorm(n);

# Residuals are heteroscedastic w.r.t. x
ob <- (x)^2 + (y)^2 + (0.2*abs(x) + 1)  * rnorm(n)
b <- bam(ob ~ s(x,k=30) + s(y, k=30), discrete = TRUE)
b <- getViz(b)

# Look at residuals along "x"
ck <- check1D(b, "x")

# Can't see that much
ck + l_dens(type = "cond", alpha = 0.8) + l_points() + l_rug(alpha = 0.2)

# Some evidence of heteroscedasticity
ck + l_densCheck()

# Compare observed residuals std dev with that of simulated data,
# heteroscedasticity is clearly visible
b <- getViz(b, nsim = 50)
check1D(b, "x") + l_gridCheck1D(gridFun = sd, show.reps = TRUE)

# This also works with factor or logical data
fac <- sample(letters, n, replace = TRUE)
logi <- sample(c(TRUE, FALSE), n, replace = TRUE)
b <- bam(ob ~ s(x,k=30) + s(y, k=30) + fac + logi, discrete = TRUE)
b <- getViz(b, nsim = 50)

# Look along "fac"
ck <- check1D(b, "fac") 
ck + l_points() + l_rug() 
ck + l_gridCheck1D(gridFun = sd)

# Look along "logi"
ck <- check1D(b, "logi") 
ck + l_points() + l_rug() 
ck + l_gridCheck1D(gridFun = sd)

}
