\name{mfdb_aggregate_na_group}
\alias{mfdb_na_group}

\title{MareFrame DB aggregate NAs}
\description{
    A decorator for other MFDB attributes to file NAs into another group,
    either one created by the main function or not.
}

\usage{
mfdb_na_group(sub_aggregate, na_group)
}

\arguments{
    \item{sub_aggregate}{An \code{mfdb_aggregate} produced by another function, e.g. \code{mfdb_step_interval}}
    \item{na_group}{The group to assign NAs to, e.g. "len_unknown"}
}

\details{
The NA group won't be added to any aggregate files generated by MFDB, since the
output would be invalid.
}

\value{
An \code{mfdb_aggregate} object that can then be used in querying functions such as
\code{mfdb_sample_count}
}

\examples{
length <- mfdb_na_group(mfdb_step_interval("len", 10), 'len_unknown')
}
