% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdd.R
\name{estimate_mdd_ss_1}
\alias{estimate_mdd_ss_1}
\alias{estimate_mdd_ss_2}
\title{Estimate marginal data density in steady-state MF-BVAR}
\usage{
estimate_mdd_ss_1(mfbvar_obj)

estimate_mdd_ss_2(mfbvar_obj, p_trunc)
}
\arguments{
\item{mfbvar_obj}{An object of class \code{mfbvar} containing the results.}

\item{p_trunc}{\code{1-p_trunc} is the degree of truncation (i.e. \code{p_trunc=1} is no truncation).}
}
\value{
\code{estimate_mdd_ss_1} returns a list with components (all are currently in logarithms):
\item{lklhd}{The likelihood.}
\item{eval_prior_Pi_Sigma}{The evaluated prior.}
\item{eval_prior_psi}{The evaluated prior of psi.}
\item{eval_RB_Pi_Sigma}{The Rao-Blackwellized estimate of the conditional posterior of Pi and Sigma.}
\item{eval_marg_psi}{The evaluated marginal posterior of psi.}
\item{log_mdd}{The mdd estimate (in log).}

\code{estimate_mdd_ss_1} returns a list with components being \code{n_reps}-long vectors and a scalar (the final estimate).
\item{eval_posterior_Pi_Sigma}{Posterior of Pi and Sigma.}
\item{data_likelihood}{The likelihood.}
\item{eval_prior_Pi_Sigma}{Prior of Pi and Sigma.}
\item{eval_prior_psi}{Prior of psi.}
\item{psi_truncated}{The truncated psi pdf.}
\item{log_mdd}{The mdd estimate (in log).}
}
\description{
This function provides the possibility to estimate the log marginal density using the steady-state MF-BVAR.
}
\details{
\code{estimate_mdd_ss_1} uses method 1, \code{estimate_mdd_ss_2} uses method 2.
}
\keyword{internal}
