% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_SMAPE.R
\name{SMAPE}
\alias{SMAPE}
\title{Symmetric Mean Absolute Percentage Error (SMAPE).}
\usage{
SMAPE(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the SMAPE for a continuous predicted-observed dataset.
}
\details{
The SMAPE (\%) is a normalized, dimensionless, and bounded (0\% to 200\%).
It is a modification of the MAPE where the denominator is half
of the sum of absolute differences between observations and predictions.
This modification solves the problem of MAPE of producing negative or undefined values.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
SMAPE(obs = X, pred = Y)
}
}
\references{
Makridakis (1993).
Accuracy measures: theoretical and practical concerns.
\emph{Int. J. Forecast. 9, 527-529.} \doi{10.1016/0169-2070(93)90079-3}
}
