% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sad.meteESF.R
\name{sad}
\alias{sad}
\alias{sad.meteESF}
\title{METE species abundance distribution}
\usage{
sad(x)

\method{sad}{meteESF}(x)
}
\arguments{
\item{x}{an object of class mete.}
}
\value{
An object of class \code{meteDist}. The object contains a list with the following elements.
\describe{
  \item{data}{The data used to construct the prediction}
  \item{d}{density funciton}
  \item{p}{cumulative density function}
  \item{q}{quantile funtion}
  \item{r}{random number generator}
  \item{La}{Vector of Lagrange multipliers}
  \item{state.var}{State variables used to constrain entropy maximization}
  \item{type}{Specifies the type of distribution is 'sad'}
}
}
\description{
\code{sad.mete} returns the species abundance distribution
predicted by METE (\eqn{\Phi(n)})
}
\details{
See Examples.
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
sad1 <- sad(esf1)
sad1
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
metePhi
}
\keyword{METE,}
\keyword{MaxEnt,}
\keyword{ecosystem}
\keyword{function}
\keyword{lagrange}
\keyword{multiplier,}
\keyword{structure}

