% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_evidence.R
\name{drop.evidence}
\alias{drop.evidence}
\title{Remove evidence classes from an object of class \dQuote{umbrella}}
\usage{
drop.evidence(x)
}
\arguments{
\item{x}{an object of class \dQuote{umbrella}}
}
\value{
Return an object of class \dQuote{umbrella} with the evidence classes dropped.
}
\description{
This function removes evidence classes previously created from an object of class \dQuote{umbrella}
}
\examples{
### perform calculations required for an umbrella review
umb.full <- umbrella(df.SMD)

### stratify evidence according to the algorithmic GRADE criteria
evid_grade <- add.evidence(umb.full, criteria = "GRADE")
is.na(evid_grade$Pharmacological$evidence)

evid_empty <- drop.evidence(evid_grade)
is.na(evid_empty$Pharmacological$evidence)
}
\references{
Fusar-Poli, P., & Radua, J. (2018). Ten simple rules for conducting umbrella reviews. \emph{Evidence-Based Mental Health}, \bold{21}, 95-100.
}
\seealso{
\code{\link{umbrella}()} for conducting an umbrella review.
}
