% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{order_cols}
\alias{order_cols}
\title{Sort Columns by Order}
\usage{
order_cols(data, metacore, dataset_name = NULL)
}
\arguments{
\item{data}{Dataset to sort}

\item{metacore}{metacore object that contains the specifications for the
dataset of interest.}

\item{dataset_name}{Optional string to specify the dataset. This is only
needed if the metacore object provided hasn't already been subsetted.}
}
\value{
dataset with ordered columns
}
\description{
This function sorts the dataset according to the order found in the
metacore object.
}
\examples{
library(metacore)
library(haven)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
data <- read_xpt(metatools_example("adsl.xpt"))
order_cols(data, spec)
}
