% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan_plot.R
\name{mc_manhattan_plot}
\alias{mc_manhattan_plot}
\title{Manhattan plot of feature-meta cluster associaiton p-values}
\usage{
mc_manhattan_plot(
  extended_solutions_matrix,
  data_list = NULL,
  target_list = NULL,
  variable_order = NULL,
  neg_log_pval_thresh = 5,
  threshold = NULL,
  point_size = 5,
  text_size = 20,
  plot_title = NULL,
  xints = NULL,
  hide_x_labels = FALSE,
  domain_colours = NULL
)
}
\arguments{
\item{extended_solutions_matrix}{A solutions_matrix that contains "_pval"
columns containing the values to be plotted. This object is the output of
\code{extend_solutions()}.}

\item{data_list}{List of dataframes containing data information.}

\item{target_list}{List of dataframes containing target information.}

\item{variable_order}{Order of features to be displayed in the plot.}

\item{neg_log_pval_thresh}{Threshold for negative log p-values.}

\item{threshold}{p-value threshold to plot horizontal dashed line at.}

\item{point_size}{Size of points in the plot.}

\item{text_size}{Size of text in the plot.}

\item{plot_title}{Title of the plot.}

\item{xints}{Either "outcomes" or a vector of numeric values to plot
vertical lines at.}

\item{hide_x_labels}{If TRUE, hides x-axis labels.}

\item{domain_colours}{Named vector of colours for domains.}
}
\value{
A Manhattan plot (class "gg", "ggplot") showing the association
p-values of features against each solution in the provided solutions matrix,
stratified by meta cluster label.
}
\description{
Given a dataframe of representative meta cluster solutions (see
\code{get_representative_solutions()}, returns a Manhattan plot for showing
feature separation across all features in provided data/target_lists.
}
