% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_propagation.R
\name{label_prop}
\alias{label_prop}
\title{Label propagation}
\usage{
label_prop(full_fused_network, clusters)
}
\arguments{
\item{full_fused_network}{Network made by running SNF on training and test
subjects together}

\item{clusters}{a vector of training subject assigned clusters in matching
order as they appear in full_fused_network}
}
\value{
new_clusters list of cluster labels for all subjects
}
\description{
Given a full fused network (one containing both pre-labeled training subjects
and unlabeled test-subjects) and the clusters of the pre-labeled subjects,
return a label propagated list of clusters for all subjects. This function
is derived from SNFtool::groupPredict. Modifications are made to take a
full fused network as input, rather than taking input dataframes and
running SNF internally. This ensures that alternative approaches to
data normalization and distance matrix calculations can be chosen by the
user.
}
