\name{plot.copas}
\alias{plot.copas}
\title{Display results of Copas selection modelling}
\description{
  Four plots (selectable by 'which') are currently available: (1) funnel
  plot, (2) contour plot, (3) treatment effect plot, (4) p-value
  for residual publication bias plot. By default, all plots are provided.
}
\usage{
\method{plot}{copas}(x,
     which=1:4,
     caption=c("Funnel plot", "Contour plot",
               "Treatment effect plot",
               "P-value for residual selection bias"),
     xlim.pp=NULL, level=0.95,
     orthogonal.line=TRUE, lines=FALSE,
     sign.rsb=x$sign.rsb, warn=-1, ...)
}
\arguments{
  \item{x}{An object of class \code{copas}, generated by the \code{copas} function}
  \item{which}{Specify plots required: 1:4 produces all plots (default);
    3 produces plot 3 etc; c(1,3) produces plots 1 and 3, and so on.}
  \item{caption}{Specify plot captions. Note that four captions must be
    specified even if fewer graphs are displayed (which is the case if
    the predefined captions are utilised). This must be
    considered if user-defined captions are provided. Captions
    corresponding to plots that are not displayed can be left empty. For
    example, if only plot 3 is selected, we might specify
    \code{caption=c("","","Plot 3","")}.}
  \item{xlim.pp}{A vector of x-axis limits for plots 3 and 4, i.e. for
    the probability of publishing the study with largest standard
    deviation. E.g. to specify limits between 0.3 and 0.1 set
    \code{xlim.pp=c(0.3,0.1)}.}
  \item{level}{The level used to calculate confidence intervals for
    plot 3 (treatment effect plot) (between 0 and 1).}
  \item{orthogonal.line}{A logical indicating whether the orthogonal
    line should be displayed in plot 2 (contour plot).}
  \item{lines}{(Diagnostic use only) A logical indicating whether
    regression lines should be plotted in contour plot. These regression
    lines attempt to summarise each contour of constant treatment effect
    by a straight line, prior to calculating the orthogonal
    line. Regression lines with a positive adjusted \code{R^2} will be
    printed in green color, others will be printed in red color.
  }
  \item{sign.rsb}{The significance level for the test of residual
    selection bias (between 0 and 1).}
  \item{warn}{A number setting the handling of warning messages. It is
    not uncommon for numerical problems to be encountered during
    estimation over the grid of (gamma0, gamma1) values. Usually this
    does not indicate a serious problem. This option specifies what to
    do with warning messages. \code{warn=-1}: ignore all warnings;
    \code{warn=0} (the default): store warnings till function finishes;
    if there are less than 10, print them, otherwise print a message
    saying warning messages were generated; \code{warn=1}: print
    warnings as they occur; \code{warn=2}: stop the function when the
    first warning is generated. For further details see
    \code{help(options)}.}
  \item{...}{other arguments to the function will be ignored (this option
          only included to conform with R standards)}
}
\details{

  Takes an object created by the \code{copas} function and draws up to
  four plots to display the results of the Copas selection modelling.

  The argument \code{which} specifies the plots to be drawn; plot numbers
  below will be produced by setting \code{which=1}, etc. 

  Plot 1:
  Funnel plot of studies in meta-analysis. Vertical grey line is usual random
  effects estimate (DerSimonian-Laird method); vertical broken
  line is fixed effects estimate.

  Plot 2:
  Plot of contours of treatment effect (estimated by the Copas model) as the
  selection probability varies (the selection probability is a function
  of gamma0 and gamma1 - see \code{help(copas)} or the reference below).

  Plot 3:
  Assuming the contours of treatment effect in Plot 2 are locally
  parallel, the results can be summarised in terms of the probability of
  publishing the study with the largest standard error. This plot
  displays the results of doing this, showing how the estimated
  treatment effect (and \code{100*level}\% confidence interval) vary as the
  probability of publishing the study with the largest standard error
  decreases.

  The three horizontal grey lines are the usual random effects treatment
  estimate (centre) +/- the \code{100*level}\% confidence interval
  (upper/lower grey lines).
  
  Plot 4:
  For any degree of selection (i.e. probability of the study with
  largest SE being published), we can calculate a p-value for the
  hypothesis that no further selection remains unexplained in the
  data. These plot displays these p-values against the probability
  that the study with the largest SE is  published.

  Under the copas selection model, probabilities of the smallest study
  being published which correspond to p-values for residual selection
  bias that are larger than 0.1 are more plausible. The corresponding
  treatment effect in plot 3 is thus the most plausible under the copas
  selection model.

  \bold{Note}

  In the current version, fine control of the graphics parameters for
  the individual panels is not possible. However, all the data used to
  create the plots can be extracted manually from the object created by
  the \code{copas} function (see attributes list for \code{copas}) and
  used to create tailor-made plots.
}

\author{James Carpenter \email{James.Carpenter@lshtm.ac.uk}, Guido
  Schwarzer \email{sc@imbi.uni-freiburg.de}}

\references{
  Carpenter JR, Schwarzer G, Rücker G, Künstler R (2009),
  Empirical evaluation showed that the Copas selection model provided
  a useful summary in 80\% of meta-analyses.
  \emph{Journal of Clinical Epidemiology}, \bold{62}, 624--31.

  Schwarzer G, Carpenter J, Rücker G (2010),
  Empirical evaluation suggests Copas selection model preferable to
  trim-and-fill method for selection bias in meta-analysis.
  \emph{Journal of Clinical Epidemiology}, \bold{63}, 282--88.
}
  

\seealso{\code{\link{copas}}, \code{\link{summary.copas}}, \code{\link[meta]{metabias}}, \code{\link[meta]{metagen}}}

\examples{
##
## Simple example:
##
## Load data
##
data(Fleiss93)
##
## Perform meta-analysis (outcome measure is OR = odds ratio)
##
meta1 <- metabin(event.e, n.e, event.c, n.c,
                 data=Fleiss93, sm="OR")
##
## Perform copas analysis
##
cop1 <- copas(meta1)
##
## Plot results
##
plot(cop1)
##
## Only do plots 1 and 2 (without orthogonal line)
##
plot(cop1, which=1:2, orth=FALSE)
##
## Another example showing use of arguments
## Note the use of \n to create a new line in the caption
##
plot(cop1,
     which=3,
     caption=c("", "",
               "Variation in estimated treatment\n effect with selection",
               ""),
     xlim.pp=c(1,0.5))
}
\keyword{hplot}
