% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_collinear_vars.R
\name{non_collinear_vars}
\alias{non_collinear_vars}
\title{Select a set of predictors with minimal multicollinearity}
\usage{
non_collinear_vars(
  .data,
  ...,
  max_vif = 10,
  missingval = "pairwise.complete.obs"
)
}
\arguments{
\item{.data}{The data set containing the variables.}

\item{...}{Variables to be submitted to selection. If \code{...} is null then
all the numeric variables from \code{.data} are used. It must be a single
variable name or a comma-separated list of unquoted variables names.}

\item{max_vif}{The maximum value for the Variance Inflation Factor
(threshold) that will be accepted in the set of selected predictors.}

\item{missingval}{How to deal with missing values. For more information,
please see \code{\link[stats]{cor}()}.}
}
\value{
A data frame showing the number of selected predictors, maximum VIF
  value, condition number, determinant value, selected predictors and removed
  predictors from the original set of variables.
}
\description{
Select a set of predictors with minimal multicollinearity using the variance
inflation factor (VIF) as criteria to remove collinear variables. The
algorithm will: \strong{(i)} compute the VIF value of the correlation matrix
containing the variables selected in \code{...}; \strong{(ii)} arrange the
VIF values and delete the variable with the highest VIF; and \strong{(iii)}
iterate step \strong{ii} until VIF value is less than or equal to
\code{max_vif}.
}
\examples{
\donttest{
library(metan)
# All numeric variables
non_collinear_vars(data_ge2)

# Select variables and choose a VIF threshold to 5
non_collinear_vars(data_ge2, EH, CL, CW, KW, NKE, max_vif = 5)
}
}
