% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_stat.R
\name{desc_stat}
\alias{desc_stat}
\alias{desc_wider}
\title{Descriptive statistics}
\usage{
desc_stat(
  .data = NULL,
  ...,
  by = NULL,
  stats = "main",
  hist = FALSE,
  level = 0.95,
  digits = 4,
  na.rm = FALSE,
  verbose = TRUE,
  plot_theme = theme_metan()
)

desc_wider(.data, which)
}
\arguments{
\item{.data}{The data to be analyzed. It can be a data frame (possible with
grouped data passed from \code{\link[dplyr]{group_by}()} or a numeric
vector. For \code{desc_wider()} \code{.data} is an object of class
\code{desc_stat}.}

\item{...}{A single variable name or a comma-separated list of unquoted
variables names. If no variable is informed, all the numeric variables from
\code{.data} will be used. Select helpers are allowed.}

\item{by}{One variable (factor) to compute the function by. It is a shortcut
to \code{\link[dplyr]{group_by}()}. To compute the statistics by more than
one grouping variable use that function.}

\item{stats}{The descriptive statistics to show. This is used to filter the
output after computation. Defaults to \code{"main"} (cv, max, mean median,
min, sd.amo, se, ci ). Other allowed values are \code{"all"} to
show all the statistics, \code{"robust"} to show robust statistics,
\code{"quantile"} to show quantile statistics, or chose one (or more) of the
following:
\itemize{
\item \code{"av.dev"}: average deviation.
\item \code{"ci"}: 95 percent confidence interval of the mean.
\item \code{"cv"}: coefficient of variation.
\item \code{"iqr"}: interquartile range.
\item \code{"gmean"}: geometric mean.
\item \code{"hmean"}: harmonic mean.
\item \code{"Kurt"}: kurtosis.
\item \code{"mad"}: median absolute deviation.
\item \code{"max"}: maximum value.
\item \code{"mean"}: arithmetic mean.
\item \code{"median"}: median.
\item \code{"min"}: minimum value.
\item \code{"n"}: the length of the data.
\item \code{"q2.5", "q25", "q75", "q97.5"}: the percentile 2.5\\%, first
quartile, third quartile, and percentile 97.5\\%, respectively.
\item \code{range}: The range of data).
\item \code{"sd.amo", "sd.pop"}: the sample and population standard deviation.
\item \code{"se"}: the standard error of the mean.
\item \code{"skew"}: skewness.
\item \code{"sum"}. the sum of the values.
\item \code{"sum.dev"}: the sum of the absolute deviations.
\item \code{"sum.sq.dev"}: the sum of the squared deviations.
\item \code{"valid.n"}: The size of sample with valid number (not NA).
\item \code{"var.amo", "var.pop"}: the sample and population variance.
}

Use a names to select the statistics. For example, \code{stats = c("median,
 mean, cv, n")}. Note that the statistic names \strong{are not}
case-sensitive. Both comma or space can be used as separator.}

\item{hist}{Logical argument defaults to \code{FALSE}. If \code{hist = TRUE}
then a histogram is created for each selected variable.}

\item{level}{The confidence level to compute the confidence interval of mean.
Defaults to 0.95.}

\item{digits}{The number of significant digits.}

\item{na.rm}{Logical. Should missing values be removed? Defaults to \code{FALSE}.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code is run
silently.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2]{theme}}.}

\item{which}{A statistic to fill the table.}
}
\value{
\itemize{
\item \code{desc_stats()} returns a tibble with the statistics in the columns and
variables (with possible grouping factors) in rows.
\item \code{desc_wider()} returns a tibble with variables in columns and grouping
factors in rows.
}
}
\description{
\itemize{
\item \code{desc_stat()} Computes the most used measures of central tendency,
position, and dispersion.
\item \code{desc_wider()} is useful to put the variables in columns and grouping
variables in rows. The table is filled with a statistic chosen with the
argument \code{stat}.
}
}
\examples{
\donttest{
library(metan)
#===============================================================#
# Example 1: main statistics (coefficient of variation, maximum,#
# mean, median, minimum, sample standard deviation, standard    #
# error and confidence interval of the mean) for all numeric    #
# variables in data                                             #
#===============================================================#

desc_stat(data_ge2)

#===============================================================#
#Example 2: robust statistics using a numeric vector as input   #
# data
#===============================================================#
vect <- data_ge2$TKW
desc_stat(vect, stats = "robust")

#===============================================================#
# Example 3: Select specific statistics. In this example, NAs   #
# are removed before analysis with a warning message            #
#===============================================================#
desc_stat(c(12, 13, 19, 21, 8, NA, 23, NA),
          stats = c('mean, se, cv, n, valid.n'),
          na.rm = TRUE)

#===============================================================#
# Example 4: Select specific variables and compute statistics by#
# levels of a factor variable (GEN)                             #
#===============================================================#
stats <-
  desc_stat(data_ge2,
            EP, EL, EH, ED, PH, CD,
            by = GEN)
stats

# To get a 'wide' format with the maximum values for all variables
desc_wider(stats, max)

#===============================================================#
# Example 5: Compute all statistics for all numeric variables   #
# by two or more factors. Note that group_by() was used to pass #
# grouped data to the function desc_stat()                      #
#===============================================================#

data_ge2 \%>\%
  group_by(ENV, GEN) \%>\%
  desc_stat()

}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
