% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse_min}
\alias{collapse_min}
\title{Collapse intensities of technical replicates by calculating their minimum}
\usage{
collapse_min(
  data,
  group_column = .data$Group,
  replicate_column = .data$Replicate,
  batch_column = .data$Batch,
  feature_metadata_cols = "Feature",
  sample_metadata_cols = NULL,
  separator = "_"
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{group_column}{Which column should be used for grouping? Usually \code{grouping_column = Group}. Uses \code{\link[rlang]{args_data_masking}}.}

\item{replicate_column}{Which column contains replicate information? Usually \code{replicate_column = Replicate}. Uses \code{\link[rlang]{args_data_masking}}.}

\item{batch_column}{Which column contains batch information? If all samples belong to the same batch (i.e., they all have the same batch identifier in the \code{batch_column}) it will have no effect on the calculation. Usually \code{batch_column = Batch}. Uses \code{\link[rlang]{args_data_masking}}.}

\item{feature_metadata_cols}{A character or character vector containing the names of the feature metadata columns. They are usually created when reading the feature table with \code{\link[metamorphr]{read_featuretable}}. Feature metadata columns not specified here will be dropped.}

\item{sample_metadata_cols}{A character or character vector containing the names of the sample metadata columns. They are usually created when joining the metadata with \code{\link[metamorphr]{join_metadata}}. Sample metadata columns not specified here will be dropped, except for \code{group_column}, \code{replicate_column} and \code{batch_column} if specified.}

\item{separator}{Separator used for joining group and replicate, or group, batch and replicate together to create the new sample names. The new sample names will be Group name, separator, Batch name, separator, Replicate name, or Group name, separator, Replicate name, in case all samples belong to the same batch (i.e., they all have the same batch identifier in the \code{batch_column}).}
}
\value{
A tibble with intensities of technical replicates collapsed.
}
\description{
Calculates the minimum of the intensity of technical replicates (e.g., if the same sample was injected multiple times or if multiple workups have been performed on the same starting material).
The function assigns new sample names by joining either group and replicate name, or if a batch column is specified group, replicate and batch together with a specified separator.
Due to the nature of the function, sample and feature metadata columns will be dropped unless they are specified with the according arguments.
}
\examples{
# uses a slightly modified version of toy_metaboscape_metadata
collapse_toy_metaboscape_metadata <- toy_metaboscape_metadata
collapse_toy_metaboscape_metadata$Replicate <- 1

toy_metaboscape \%>\%
  join_metadata(collapse_toy_metaboscape_metadata) \%>\%
  impute_lod() \%>\%
  collapse_min(group_column = Group, replicate_column = Replicate)

}
