% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{plot.minima}
\alias{plot.minima}
\title{Plot minima object}
\usage{
\method{plot}{minima}(x, plottype = "both", xlim = NULL, ylim = NULL,
  zlim = NULL, colscale = F, colscalelab = "free energy",
  main = NULL, sub = NULL, xlab = NULL, ylab = NULL,
  nlevels = 10, levels = NULL, col = rainbow(135)[100:1],
  labels = NULL, labcex = 0.6, drawlabels = TRUE,
  method = "flattest", textcol = "black", pch = 1, bg = "red",
  cex = 1, contcol = par("fg"), lty = par("lty"), lwd = par("lwd"),
  asp = NULL, axes = TRUE, ...)
}
\arguments{
\item{x}{minima object.}

\item{plottype}{specifies whether 2D free energy surface will be plotted
as image, contours or both (default "both").}

\item{xlim}{numeric vector of length 2, giving the x coordinates range.}

\item{ylim}{numeric vector of length 2, giving the y coordinates range.}

\item{zlim}{numeric vector of length 2, giving the z coordinates range.}

\item{colscale}{specifies whether color scale will be plotted (default False).}

\item{colscalelab}{color scale label (default "free energy").}

\item{main}{an overall title for the plot: see 'title'.}

\item{sub}{a sub title for the plot: see 'title'.}

\item{xlab}{a title for the x axis: see 'title'.}

\item{ylab}{a title for the y axis: see 'title'.}

\item{nlevels}{number of contour levels desired if 'levels' is not
supplied.}

\item{levels}{numeric vector of levels at which to draw contour lines.}

\item{col}{color of the free energy surface. For 1D surface it is the color
of the line. For 2D it is a list of colors such as that generated by
'rainbow', 'heat.colors', 'topo.colors', 'terrain.colors' or similar
functions (default=rainbow(135)[100:1]).}

\item{labels}{a vector giving the labels for the contour lines.  If 'NULL'
then the levels are used as labels, otherwise this is coerced
by 'as.character'.}

\item{labcex}{'cex' for contour labeling. This is an absolute size, not a
multiple of 'par("cex")'.}

\item{drawlabels}{logical. Contours are labeled if 'TRUE'.}

\item{method}{character string specifying where the labels will be located.
Possible values are '"simple"', '"edge"' and '"flattest"'
(the default). See the 'Details' section.}

\item{textcol}{color of minima labels.}

\item{pch}{plotting 'character', i.e., symbol to use. See 'points'}

\item{bg}{background (fill) color for the open plot symbols given by
'pch = 21:25'.}

\item{cex}{character (or symbol) expansion: a numerical vector. This
works as a multiple of 'par("cex")'.}

\item{contcol}{contour color.}

\item{lty}{line type for the lines drawn.}

\item{lwd}{contour line width.}

\item{asp}{the y/x aspect ratio, see 'plot.window'.}

\item{axes}{a logical value indicating whether both axes should be drawn
on the plot.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
`plot.minima` plots free energy surface with minima. The free energy surface is plotted the same
way as by plot.fes with additional minima labels.
}
\examples{
tfes<-fes(acealanme, imax=5000)
minima<-fesminima(tfes)
plot(minima)
}
