% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_builder.R
\name{spec_type_to_codelist}
\alias{spec_type_to_codelist}
\title{Spec to codelist}
\usage{
spec_type_to_codelist(
  doc,
  codelist_cols = c(code_id = "ID", name = "[N|n]ame", code = "^[C|c]ode|^[T|t]erm",
    decode = "[D|d]ecode"),
  permitted_val_cols = NULL,
  dict_cols = c(code_id = "ID", name = "[N|n]ame", dictionary = "[D|d]ictionary",
    version = "[V|v]ersion"),
  sheets = NULL,
  simplify = TRUE
)
}
\arguments{
\item{doc}{Named list of datasets @seealso \code{\link[=read_all_sheets]{read_all_sheets()}} for exact
format}

\item{codelist_cols}{Named vector of column names that make up the codelist.
The column names can be regular expressions for more flexibility. But, the
names must follow the given pattern}

\item{permitted_val_cols}{Named vector of column names that make up the
permitted value The column names can be regular expressions for more
flexibility. This is optional, can be left as null if there isn't a
permitted value sheet}

\item{dict_cols}{Named vector of column names that make up the dictionary
value The column names can be regular expressions for more flexibility.
This is optional, can be left as null if there isn't a permitted value
sheet}

\item{sheets}{Optional, regular expressions of the sheets}

\item{simplify}{Boolean value, if true will convert code/decode pairs that
are all equal to a permitted value list}
}
\value{
a dataset formatted for the metacore object
}
\description{
Creates the value_spec from a list of datasets (optionally filtered by the
sheet input). The named vector \verb{*_cols} is used to determine which is the
correct sheet and renames the columns.
}
\seealso{
Other spec builder: 
\code{\link{spec_type_to_derivations}()},
\code{\link{spec_type_to_ds_spec}()},
\code{\link{spec_type_to_ds_vars}()},
\code{\link{spec_type_to_value_spec}()},
\code{\link{spec_type_to_var_spec}()}
}
\concept{spec builder}
