% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R, R/old_taxa--internal.R
\name{limited_print}
\alias{limited_print}
\title{Print a subset of a character vector}
\usage{
limited_print(
  chars,
  prefix = "",
  sep = ", ",
  mid = " ... ",
  trunc_char = "[truncated]",
  max_chars = getOption("width") - nchar(prefix) - 5,
  type = "message"
)

limited_print(
  chars,
  prefix = "",
  sep = ", ",
  mid = " ... ",
  trunc_char = "[truncated]",
  max_chars = getOption("width") - nchar(prefix) - 5,
  type = "message"
)
}
\arguments{
\item{chars}{(`character`) What to print.}

\item{prefix}{(`character` of length 1) What to print before
`chars`, on the same line.}

\item{sep}{What to put between consecutive values}

\item{mid}{What is used to indicate omitted values}

\item{max_chars}{(`numeric` of length 1) The maximum number of
characters to print.}

\item{type}{(`"error"`, `"warning"`, `"message"`, `"cat"`, `"print"`, `"silent"`, `"plain"`)}

\item{trunc}{What is appended onto truncated values}
}
\value{
`NULL`

`NULL`
}
\description{
Prints the start and end values for a character vector. The number of values
printed depend on the width of the screen by default.

Prints the start and end values for a character vector. The number of values
printed depend on the width of the screen by default.
}
\keyword{internal}
