% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{classifications}
\alias{classifications}
\title{Get classifications of taxa}
\arguments{
\item{obj}{([taxonomy()] or [taxmap()])}

\item{value}{What data to return. Any result of `all_names(obj)` can be used,
but it usually only makes sense to data that corresponds to taxa 1:1, such
as [taxon_ranks()]. By default, taxon indexes are returned.}

\item{sep}{(`character` of length 1) The character(s) to place between
taxon IDs}
}
\value{
`character`
}
\description{
Get character vector classifications of taxa in an object of type
[taxonomy()] or [taxmap()] composed of data associated with taxa. Each
classification is constructed by concatenating the data of the given taxon
and all of its supertaxa.
\preformatted{
obj$classifications(value = "taxon_names", sep = ";")
classifications(obj, value = "taxon_names", sep = ";")}
}
\examples{
# Defualt settings returns taxon names separated by ;
classifications(ex_taxmap)

# Other values can be returned besides taxon names
classifications(ex_taxmap, value = "taxon_ids")

# The separator can also be changed
classifications(ex_taxmap, value = "taxon_ranks", sep = "||")

}
\seealso{
Other taxonomy data functions: 
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data_}()},
\code{\link{map_data}()},
\code{\link{n_leaves_1}()},
\code{\link{n_leaves}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
