% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{calc_n_samples}
\alias{calc_n_samples}
\title{Count the number of samples}
\usage{
calc_n_samples(obj, dataset, cols = NULL, groups = NULL, out_names = NULL,
  drop = FALSE, append = FALSE)
}
\arguments{
\item{obj}{A \code{\link[taxa]{taxmap}} object}

\item{dataset}{The name of a table in \code{obj} that contains counts.}

\item{cols}{The names/indexes of columns in \code{data} that have counts. By
Default, all numeric columns in \code{data} are used.}

\item{groups}{Group counts of multiple columns per treatment/group. This
should be a vector of group IDs (e.g. character, integer) the same length
as \code{cols} that defines which samples go in which group. When used,
there will be one column in the output for each unique value in
\code{groups}.}

\item{out_names}{The names of count columns in the output. Must be the length
1 or same length as \code{unique(groups)}, if used.}

\item{drop}{If \code{groups} is not used, return a vector of the results instead
of a table with one column.}

\item{append}{If \code{TRUE}, append results to input table and return.}
}
\value{
A tibble
}
\description{
For a given table in a \code{\link[taxa]{taxmap}} object, count the number of
samples with greater than zero occurrences.
}
\examples{
\dontrun{
# Parse dataset for example
x = parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                   class_key = c(tax_rank = "info", tax_name = "taxon_name"),
                   class_regex = "^(.+)__(.+)$")
                   
# Count samples with reads
calc_n_samples(x, dataset = "tax_data")

# Return a vector instead of a table
calc_n_samples(x, dataset = "tax_data", drop = TRUE)

# Only use some columns
calc_n_samples(x, dataset = "tax_data", cols = hmp_samples$sample_id[1:5])

# Return a count for each treatment
calc_n_samples(x, dataset = "tax_data", groups = hmp_samples$body_site)

# Rename output columns 
calc_n_samples(x, dataset = "tax_data", groups = hmp_samples$body_site,
               out_names = c("A", "B", "C", "D", "E"))

# Add results to input table
calc_n_samples(x, dataset = "tax_data", append = TRUE)
}

}
\seealso{
Other calculations: \code{\link{calc_obs_props}},
  \code{\link{calc_taxon_abund}},
  \code{\link{compare_groups}}, \code{\link{rarefy_obs}},
  \code{\link{zero_low_counts}}
}
