% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submnet.R
\name{submnet}
\alias{submnet}
\title{Simulation of gene removal-based submodel series with a given ranking}
\usage{
submnet(model, fn, rank.best = "expr", gene.sets = NULL, mc.cores = 1,
  obj.react = NA, tol = SYBIL_SETTINGS("TOLERANCE"))
}
\arguments{
\item{model}{An object of class \code{modelorg} indicating the weighted \code{rescue} model obtained from the rescue process.}

\item{fn}{An object returned by the fitness function.}

\item{rank.best}{Name of a ranking among simulated ones. Default: "expr".}

\item{gene.sets}{Named list of gene sets for gene set enrichment analysis. Default: NULL,
depletion fraction of gene sets should be further computed for gene set enrichment analysis.}

\item{mc.cores}{The number of cores to use (at least 1), i.e. at most how many child processes will be run simultaneously. Default: 1.}

\item{obj.react}{A string indicating objective reaction ID. Default: reaction producing BIOMASS.}

\item{tol}{The maximum value to be considered null. Default: \code{SYBIL_SETTINGS("TOLERANCE")}.}
}
\value{
An object of class \code{scoreGeneDel} for the submodel construction simulation.
}
\description{
This function simulates the construction of a series of submodels by removing genes in a given ranking.
}
\examples{
data(Ec_core)
mod <- rescue(Ec_core, target=0.1)
mod.weight <- changeObjFunc(mod$rescue, react=rownames(mod$coef), obj_coef=mod$coef)
ranks <- list(rep.1=data.frame(expr=setNames(rnorm(length(sybil::allGenes(mod.weight)),
                                             mean=5, sd=4), sybil::allGenes(mod.weight))),
              rep.2=data.frame(expr=setNames(rnorm(length(sybil::allGenes(mod.weight)),
                                             mean=5, sd=4.1), sybil::allGenes(mod.weight))))
fn <- fitness(model=mod.weight, ranks=ranks, step=200, draw.num=1)
gene.sets <- list(X1=head(sybil::allGenes(mod.weight)), X2=tail(sybil::allGenes(mod.weight)))
sgd <- submnet(model=mod.weight, fn=fn, rank.best="expr",
               obj.react="Biomass_Ecoli_core_w_GAM", gene.sets=gene.sets)
}
