% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSTplot.R
\name{RMSTplot}
\alias{RMSTplot}
\title{Plot RMST curves in each trial and combined effects}
\usage{
RMSTplot(RMSTobject, type = "l", col = c("red", "blue", "green",
  "orange", "purple", "yellow", "brown", "gray"), lwd = 2,
  ylim = c(-0.75, 2.75), yby = 0.25, xlim = c(0, 36), xby = 12,
  main = "", xlab = "Time (unit)",
  ylab = "Difference in RMST (unit)", trial_legend = TRUE,
  MA_legend = TRUE, estimates = TRUE)
}
\arguments{
\item{RMSTobject}{object created by RMSTcurves}

\item{type}{specify plot type (defaults to line plot)}

\item{col}{option to specify vector of colors for each study}

\item{lwd}{option to specify line width}

\item{ylim}{option to specify limits for y axis}

\item{yby}{option to specify intervals for y axis}

\item{xlim}{option to specify limits for x axis}

\item{xby}{option to specify intervals for x axis}

\item{main}{option to add title}

\item{xlab}{option to specify x axis label}

\item{ylab}{option to specify y axis label}

\item{trial_legend}{option to include a legend for trial colors}

\item{MA_legend}{option to include a legend for meta-analysis symbols}

\item{estimates}{option to include meta-analysis estimates and CIs}
}
\value{
a plot of RMSTD over time with option to add combined effect estimates and pointwise 95% confidence intervals
}
\description{
Plot the \code{RMSTcurve} object
}
