% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fns.R
\name{rand.eff.coord.desc.unpenalized}
\alias{rand.eff.coord.desc.unpenalized}
\title{Cyclical coordinate descent algorithm for the M-step in the EM Algorithm for the maximizing the soft constraint model likelihood.}
\usage{
rand.eff.coord.desc.unpenalized(
  Y,
  M,
  A,
  C = NULL,
  first.moment,
  second.moment,
  err.tol.out = 1e-08,
  err.tol.med = 1e-08,
  max.itr = 10000
)
}
\arguments{
\item{Y}{A (n x 1) continuous outcome vector.}

\item{M}{A (n x p_m) matrix of mediators.}

\item{A}{A (n x 1) vector of exposures.}

\item{C}{A (n x p_c) matrix of confounders and adjustment covariates. If there are no confounders or adjustment covariates set C = NULL.}

\item{first.moment}{Posterior expectation of the total effect parameter.}

\item{second.moment}{Posterior expection of the squared total effect parameter.}

\item{err.tol.out}{Termination condition for cyclical coordinate descent algorithm with respect to the outcome model parameters.}

\item{err.tol.med}{Termination condition for cyclical coordinate descent algorithm with respect to the mediator model parameters.}

\item{max.itr}{Maximum number of iterations for cyclical coordinate descent algorithm.}
}
\value{
A list containing point estimates of the soft constraint model parameters and an indicator of whether the algorithm converges.
}
\description{
Cyclical coordinate descent algorithm for the M-step in the EM Algorithm for the maximizing the soft constraint model likelihood.
}
