% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{common_subgraph_stats}
\alias{common_subgraph_stats}
\title{Common subgraph statistics}
\usage{
common_subgraph_stats(adj_1, adj_2, giant = FALSE, weights_1 = NULL,
  weights_2 = NULL, mode_1 = "undirected", mode_2 = "undirected")
}
\arguments{
\item{adj_1}{numeric matrix representing the adjacency matrix of graph 1.}

\item{adj_2}{numeric matrix representing the adjacency matrix of graph 2.}

\item{giant}{logical specifying whether the should be computed for the
largest component.}

\item{weights_1}{numeric vector of edge weights for network 1 and
2, respectively. Optional.}

\item{weights_2}{numeric vector of edge weights for network 1 and
2, respectively. Optional.}

\item{mode_1}{character, either \code{"directed"} or \code{"undirected"},
specifying whether network 1 and 2 should be interepeted as directed
or undirected, respectively. Defaults to \code{"undirected"}.}

\item{mode_2}{character, either \code{"directed"} or \code{"undirected"},
specifying whether network 1 and 2 should be interepeted as directed
or undirected, respectively. Defaults to \code{"undirected"}.}
}
\value{
List containing the two subgraphs.
}
\description{
Function identifies the common subgraphs of two networks and returns the
networks statistics using \link{network_stats}.
}
\examples{

# get fluency data
data(animal_fluency)

# edge lists of fluency graphs
edge_list_1 = threshold_graph(animal_fluency[1:100])
edge_list_2 = threshold_graph(animal_fluency[101:200])

# get adjacency matrices
adj_1 = edg_to_adj(edge_list_1)
adj_2 = edg_to_adj(edge_list_2)

# get structural overview of both networks
common_subgraph_stats(adj_1, adj_2)

}
