% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt-package.R
\docType{package}
\name{melt-package}
\alias{melt}
\alias{melt-package}
\title{melt: Multiple Empirical Likelihood Tests}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Performs multiple empirical likelihood tests for linear and generalized linear models. The package offers an easy-to-use interface and flexibility in specifying hypotheses and calibration methods, extending the framework to simultaneous inferences. The core computational routines are implemented using the 'Eigen' C++ library and 'RcppEigen' interface, with OpenMP for parallel computation. Details of the testing procedures are given in Kim, MacEachern, and Peruggia (2021) \href{https://arxiv.org/abs/2112.09206}{arXiv:2112.09206}. This work was supported by the U.S. National Science Foundation under Grants No. SES-1921523 and DMS-2015552.
}
\references{
Kim E, MacEachern S, Peruggia M (2021).
  “Empirical Likelihood for the Analysis of Experimental Designs.”
  arxiv:2112.09206. URL <https://arxiv.org/abs/2112.09206>.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/melt/}
  \item \url{https://github.com/ropensci/melt}
  \item Report bugs at \url{https://github.com/ropensci/melt/issues}
}

}
\author{
\strong{Maintainer}: Eunseop Kim \email{kim.7302@osu.edu}

Other contributors:
\itemize{
  \item Steven MacEachern [contributor, thesis advisor]
  \item Mario Peruggia [contributor, thesis advisor]
  \item Pierre Chausse [reviewer]
  \item Alex Stringer [reviewer]
}

}
\keyword{internal}
