% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/formula-methods.R
\docType{class}
\name{LM-class}
\alias{LM-class}
\alias{LM}
\alias{formula,LM-method}
\title{\linkS4class{LM} class}
\description{
S4 class for linear models with empirical likelihood. It inherits from
\linkS4class{CEL} class.
}
\details{
If there is no intercept in a model, \code{optim} slot need to be
understood in terms of \linkS4class{EL} class since constrained
optimization is not involved in the overall test.
}
\section{Methods (by generic)}{
\itemize{
\item \code{formula}: Extracts the symbolic model formula used in \code{\link[=el_lm]{el_lm()}} or
\code{\link[=el_glm]{el_glm()}}.
}}

\section{Slots}{

\describe{
\item{\code{parTests}}{A list with the test results for each parameter:
\itemize{
\item{\code{statistic } }{A numeric vector of the empirical likelihood
ratio statistics.}
\item{\code{convergence } }{A logical vector of the convergence status of
tests for each parameter.}
}}

\item{\code{misc}}{A list with miscellaneous outputs from a model fitting function.
They are used in other generics and methods.}
}}

\examples{
showClass("LM")
}
