% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{el_mean}
\alias{el_mean}
\title{Empirical likelihood test for mean}
\usage{
el_mean(theta, x, maxit = 50L, abstol = 1e-08)
}
\arguments{
\item{theta}{Numeric vector of parameters to be tested.}

\item{x}{Numeric matrix or vector of data. If \code{x} is a matrix, each row corresponds to an observation.}

\item{maxit}{Maximum number of iterations for optimization. Defaults to 50.}

\item{abstol}{Absolute convergence tolerance for optimization. Defaults to 1e-08.}
}
\value{
A list with class \code{c("mean", "melt")}.
}
\description{
Computes empirical likelihood for mean parameter.
}
\examples{
## scalar mean
theta <- 0
x <- rnorm(100)
el_mean(theta, x)

## vector mean
x <- matrix(rnorm(100), ncol = 2)
theta <- c(0, 0)
el_mean(theta, x)

}
