% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_summary.R
\name{simulation_summary}
\alias{simulation_summary}
\title{Summarizes spatial simulation results}
\usage{
simulation_summary(object, summary_function, ...)
}
\arguments{
\item{object}{An object of class 'sf' simulation results (e.g. the result of calling \code{\link{spwb_spatial}}).}

\item{summary_function}{The summary function to be executed on simulation results (see details).}

\item{...}{Additional parameters to the summary function.}
}
\value{
An object of class \code{\link{sf}}, with the following two elements:
\itemize{
\item{\code{geometry}: Spatial geometry.}
\item{\code{id}: Stand id, taken from the input.}
\item{\code{summary}: A list of model output summaries for each simulated location.}
}
}
\description{
Creates spatial objects containing summaries of simulations
}
\details{
The function supplied should take as input an object of local simulation function, i.e. \code{\link{spwb}}, \code{\link{growth}}, or \code{\link{fordyn}}.
The output should be a matrix with dates as rows and variables in columns.
An example of suitable function is \code{\link{summary.spwb}}.
}
\seealso{
\code{\link{spwb_spatial}}, \code{\link{plot_summary}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF.
}
